/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.wrapper;

import com.ulisesbocchio.jasyptspringboot.EncryptablePropertySource;
import com.ulisesbocchio.jasyptspringboot.util.Iterables;
import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.InvalidConfigurationPropertyNameException;
import org.springframework.boot.origin.Origin;
import org.springframework.core.env.PropertySource;

public class EncryptableConfigurationPropertySourcesPropertySource
extends PropertySource<Iterable<ConfigurationPropertySource>>
implements EncryptablePropertySource<Iterable<ConfigurationPropertySource>> {
    private final PropertySource<Iterable<ConfigurationPropertySource>> delegate;

    public EncryptableConfigurationPropertySourcesPropertySource(PropertySource<Iterable<ConfigurationPropertySource>> delegate) {
        super(delegate.getName(), Iterables.filter((Iterable)delegate.getSource(), configurationPropertySource -> !configurationPropertySource.getUnderlyingSource().getClass().equals(EncryptableConfigurationPropertySourcesPropertySource.class)));
        this.delegate = delegate;
    }

    @Override
    public PropertySource<Iterable<ConfigurationPropertySource>> getDelegate() {
        return this.delegate;
    }

    @Override
    public void refresh() {
    }

    @Override
    public Object getProperty(String name) {
        ConfigurationProperty configurationProperty = this.findConfigurationProperty(name);
        return configurationProperty != null ? configurationProperty.getValue() : null;
    }

    @Override
    public Origin getOrigin(String name) {
        return Origin.from((Object)this.findConfigurationProperty(name));
    }

    private ConfigurationProperty findConfigurationProperty(String name) {
        try {
            return this.findConfigurationProperty(ConfigurationPropertyName.of((CharSequence)name));
        }
        catch (InvalidConfigurationPropertyNameException ex) {
            if (ex.getInvalidCharacters().size() == 1 && ((Character)ex.getInvalidCharacters().get(0)).equals(Character.valueOf('.'))) {
                return null;
            }
            throw ex;
        }
    }

    private ConfigurationProperty findConfigurationProperty(ConfigurationPropertyName name) {
        if (name == null) {
            return null;
        }
        for (ConfigurationPropertySource configurationPropertySource : (Iterable)this.getSource()) {
            ConfigurationProperty configurationProperty;
            if (configurationPropertySource.getUnderlyingSource().getClass().equals(EncryptableConfigurationPropertySourcesPropertySource.class) || (configurationProperty = configurationPropertySource.getConfigurationProperty(name)) == null) continue;
            return configurationProperty;
        }
        return null;
    }
}

