/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.encryptor;

import java.util.Base64;
import org.jasypt.encryption.pbe.PBEByteEncryptor;
import org.jasypt.encryption.pbe.PBEStringEncryptor;

public class SimplePBEStringEncryptor
implements PBEStringEncryptor {
    private final PBEByteEncryptor delegate;

    public SimplePBEStringEncryptor(PBEByteEncryptor delegate) {
        this.delegate = delegate;
    }

    public String encrypt(String message) {
        return Base64.getEncoder().encodeToString(this.delegate.encrypt(message.getBytes("UTF-8")));
    }

    public String decrypt(String encryptedMessage) {
        return new String(this.delegate.decrypt(Base64.getDecoder().decode(encryptedMessage)), "UTF-8");
    }

    public void setPassword(String password) {
        throw new IllegalAccessException("Not Implemented, use delegate");
    }
}

