/*
 * Decompiled with CFR 0.152.
 */
package com.trickl.flux.publishers;

import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.reactivestreams.Publisher;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import reactor.core.publisher.Flux;

public class MessageTopicBroadcaster<T>
implements Supplier<Publisher<T>> {
    private static final Logger log = Logger.getLogger(MessageTopicBroadcaster.class.getName());
    private final Publisher<T> source;
    private final SimpMessagingTemplate messagingTemplate;
    private final String destination;
    private final Publisher<T> publisher;

    public MessageTopicBroadcaster(Publisher<T> source, SimpMessagingTemplate messagingTemplate, String destination) {
        this.source = source;
        this.messagingTemplate = messagingTemplate;
        this.destination = destination;
        this.publisher = Flux.from(this.source).doOnNext(this::sendMessage).publish().refCount();
    }

    @Override
    public Publisher<T> get() {
        return this.publisher;
    }

    void sendMessage(T value) {
        log.log(Level.FINE, "\u001b[32mSENDING  \u2191 {0}\u001b[0m on {1}", new Object[]{value, this.destination});
        this.messagingTemplate.convertAndSend((Object)this.destination, value);
    }
}

