/**
 * Copyright (C) 2015 Anthony K. Trinh
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.github.tony19;

/**
 * Loggly client interface
 *
 * @author tony19@gmail.com
 * @since 1.0.0
 */
public interface ILogglyClient{

    /**
     * Writes a single log event
     * @param message log event to be written
     * @return {@code true} if successful; {@code false} otherwise
     */
    boolean log(String message);

    /**
     * Writes multiple log events at once
     * @param messages log events to be written
     * @return {@code true} if successful; {@code false} otherwise
     */
    boolean logBulk(String... messages);
}
