/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.spi;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.spi.AppenderAttachable;
import ch.qos.logback.core.util.COWArrayList;
import java.util.Iterator;

public class AppenderAttachableImpl<E>
implements AppenderAttachable<E> {
    private final COWArrayList<Appender<E>> appenderList = new COWArrayList<Appender>(new Appender[0]);
    static final long START = System.currentTimeMillis();

    @Override
    public void addAppender(Appender<E> appender) {
        if (appender == null) {
            throw new IllegalArgumentException("Null argument disallowed");
        }
        this.appenderList.addIfAbsent(appender);
    }

    public int appendLoopOnAppenders(E e) {
        int n = 0;
        Appender<E>[] appenderArray = this.appenderList.asTypedArray();
        int n2 = appenderArray.length;
        for (int i = 0; i < n2; ++i) {
            appenderArray[i].doAppend(e);
            ++n;
        }
        return n;
    }

    @Override
    public Iterator<Appender<E>> iteratorForAppenders() {
        return this.appenderList.iterator();
    }

    @Override
    public Appender<E> getAppender(String string) {
        if (string == null) {
            return null;
        }
        for (Appender<E> appender : this.appenderList) {
            if (!string.equals(appender.getName())) continue;
            return appender;
        }
        return null;
    }

    @Override
    public boolean isAttached(Appender<E> appender) {
        if (appender == null) {
            return false;
        }
        for (Appender<E> appender2 : this.appenderList) {
            if (appender2 != appender) continue;
            return true;
        }
        return false;
    }

    @Override
    public void detachAndStopAllAppenders() {
        for (Appender<E> appender : this.appenderList) {
            appender.stop();
        }
        this.appenderList.clear();
    }

    @Override
    public boolean detachAppender(Appender<E> appender) {
        if (appender == null) {
            return false;
        }
        boolean bl = this.appenderList.remove(appender);
        return bl;
    }

    @Override
    public boolean detachAppender(String string) {
        if (string == null) {
            return false;
        }
        boolean bl = false;
        for (Appender<E> appender : this.appenderList) {
            if (!string.equals(appender.getName())) continue;
            bl = this.appenderList.remove(appender);
            break;
        }
        return bl;
    }
}

