/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.android;

import android.annotation.TargetApi;
import android.content.ContextWrapper;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Environment;
import ch.qos.logback.core.Context;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class AndroidContextUtil {
    private ContextWrapper context;

    public AndroidContextUtil() {
        this(AndroidContextUtil.getContext());
    }

    public AndroidContextUtil(ContextWrapper contextWrapper) {
        this.context = contextWrapper;
    }

    public static boolean containsProperties(String string) {
        return string.contains("DATA_DIR") || string.contains("EXT_DIR") || string.contains("PACKAGE_NAME") || string.contains("VERSION_CODE") || string.contains("VERSION_NAME");
    }

    public void setupProperties(Context context) {
        context.putProperty("DATA_DIR", this.getFilesDirectoryPath());
        String string = this.getMountedExternalStorageDirectoryPath();
        if (string != null) {
            context.putProperty("EXT_DIR", string);
        }
        context.putProperty("PACKAGE_NAME", this.getPackageName());
        context.putProperty("VERSION_CODE", this.getVersionCode());
        context.putProperty("VERSION_NAME", this.getVersionName());
    }

    protected static ContextWrapper getContext() {
        try {
            Class<?> clazz = Class.forName("android.app.AppGlobals");
            Method method = clazz.getDeclaredMethod("getInitialApplication", new Class[0]);
            return (ContextWrapper)method.invoke(clazz, new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    public String getMountedExternalStorageDirectoryPath() {
        String string = null;
        String string2 = Environment.getExternalStorageState();
        if ("mounted".equals(string2) || "mounted_ro".equals(string2)) {
            string = this.getExternalStorageDirectoryPath();
        }
        return string;
    }

    @TargetApi(value=8)
    public String getExternalStorageDirectoryPath() {
        if (Build.VERSION.SDK_INT >= 29) {
            return this.getExternalFilesDirectoryPath();
        }
        return this.absPath(Environment.getExternalStorageDirectory());
    }

    @TargetApi(value=8)
    public String getExternalFilesDirectoryPath() {
        return this.context != null ? this.absPath(this.context.getExternalFilesDir(null)) : "";
    }

    public String getCacheDirectoryPath() {
        return this.context != null ? this.absPath(this.context.getCacheDir()) : "";
    }

    public String getExternalCacheDirectoryPath() {
        return this.context != null ? this.absPath(this.context.getExternalCacheDir()) : "";
    }

    public String getPackageName() {
        return this.context != null ? this.context.getPackageName() : "";
    }

    public String getFilesDirectoryPath() {
        return this.context != null ? this.absPath(this.context.getFilesDir()) : "";
    }

    @TargetApi(value=21)
    public String getNoBackupFilesDirectoryPath() {
        return Build.VERSION.SDK_INT >= 21 && this.context != null ? this.absPath(this.context.getNoBackupFilesDir()) : "";
    }

    public String getDatabaseDirectoryPath() {
        return this.context != null && this.context.getDatabasePath("x") != null ? this.context.getDatabasePath("x").getParent() : "";
    }

    public String getDatabasePath(String string) {
        return this.context != null ? this.absPath(this.context.getDatabasePath(string)) : "";
    }

    public String getVersionCode() {
        String string = "";
        if (this.context != null) {
            try {
                PackageInfo packageInfo = this.context.getPackageManager().getPackageInfo(this.getPackageName(), 0);
                string = "" + packageInfo.versionCode;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        return string;
    }

    public String getVersionName() {
        String string = "";
        if (this.context != null) {
            try {
                PackageInfo packageInfo = this.context.getPackageManager().getPackageInfo(this.getPackageName(), 0);
                string = packageInfo.versionName;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        return string != null ? string : "";
    }

    private String absPath(File file) {
        return file != null ? file.getAbsolutePath() : "";
    }
}

