/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.rolling.RolloverFailure;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.OptionHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;

public class FileUtil
extends ContextAwareBase {
    static final int BUF_SIZE = 32768;

    public FileUtil(Context context) {
        this.setContext(context);
    }

    public static boolean createMissingParentDirectories(File file) {
        File file2 = file.getParentFile();
        if (file2 == null) {
            return true;
        }
        file2.mkdirs();
        return file2.exists();
    }

    public static String prefixRelativePath(String string, String string2) {
        if (string != null && !OptionHelper.isEmpty(string.trim()) && !new File(string2).isAbsolute()) {
            string2 = string + "/" + string2;
        }
        return string2;
    }

    public void copy(String string, String string2) throws RolloverFailure {
        BufferedInputStream bufferedInputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            int n;
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
            byte[] byArray = new byte[32768];
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
            }
            bufferedInputStream.close();
            bufferedInputStream = null;
            filterOutputStream.close();
            filterOutputStream = null;
        }
        catch (IOException iOException) {
            String string3 = "Failed to copy [" + string + "] to [" + string2 + "]";
            this.addError(string3, iOException);
            throw new RolloverFailure(string3);
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

