/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

import ch.qos.logback.core.pattern.parser.Token;
import ch.qos.logback.core.pattern.parser.TokenStream;
import ch.qos.logback.core.pattern.util.AsIsEscapeUtil;
import ch.qos.logback.core.pattern.util.IEscapeUtil;
import ch.qos.logback.core.spi.ScanException;
import java.util.ArrayList;
import java.util.List;

public class OptionTokenizer {
    private static final int EXPECTING_STATE = 0;
    private static final int RAW_COLLECTING_STATE = 1;
    private static final int QUOTED_COLLECTING_STATE = 2;
    final IEscapeUtil escapeUtil;
    final TokenStream tokenStream;
    final String pattern;
    final int patternLength;
    char quoteChar;
    int state = 0;

    OptionTokenizer(TokenStream tokenStream) {
        this(tokenStream, new AsIsEscapeUtil());
    }

    OptionTokenizer(TokenStream tokenStream, IEscapeUtil iEscapeUtil) {
        this.tokenStream = tokenStream;
        this.pattern = tokenStream.pattern;
        this.patternLength = tokenStream.patternLength;
        this.escapeUtil = iEscapeUtil;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void tokenize(char c, List<Token> list) throws ScanException {
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList = new ArrayList<String>();
        char c2 = c;
        while (this.tokenStream.pointer < this.patternLength) {
            block0 : switch (this.state) {
                case 0: {
                    switch (c2) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': 
                        case ',': {
                            break block0;
                        }
                        case '\"': 
                        case '\'': {
                            this.state = 2;
                            this.quoteChar = c2;
                            break block0;
                        }
                        case '}': {
                            this.emitOptionToken(list, arrayList);
                            return;
                        }
                    }
                    stringBuffer.append(c2);
                    this.state = 1;
                    break;
                }
                case 1: {
                    switch (c2) {
                        case ',': {
                            arrayList.add(stringBuffer.toString().trim());
                            stringBuffer.setLength(0);
                            this.state = 0;
                            break block0;
                        }
                        case '}': {
                            arrayList.add(stringBuffer.toString().trim());
                            this.emitOptionToken(list, arrayList);
                            return;
                        }
                    }
                    stringBuffer.append(c2);
                    break;
                }
                case 2: {
                    if (c2 == this.quoteChar) {
                        arrayList.add(stringBuffer.toString());
                        stringBuffer.setLength(0);
                        this.state = 0;
                        break;
                    }
                    if (c2 == '\\') {
                        this.escape(String.valueOf(this.quoteChar), stringBuffer);
                        break;
                    }
                    stringBuffer.append(c2);
                }
            }
            c2 = this.pattern.charAt(this.tokenStream.pointer);
            ++this.tokenStream.pointer;
        }
        if (c2 != '}') throw new ScanException("Unexpected end of pattern string in OptionTokenizer");
        if (this.state == 0) {
            this.emitOptionToken(list, arrayList);
            return;
        } else {
            if (this.state != 1) throw new ScanException("Unexpected end of pattern string in OptionTokenizer");
            arrayList.add(stringBuffer.toString().trim());
            this.emitOptionToken(list, arrayList);
        }
    }

    void emitOptionToken(List<Token> list, List<String> list2) {
        list.add(new Token(1006, list2));
        this.tokenStream.state = TokenStream.TokenizerState.LITERAL_STATE;
    }

    void escape(String string, StringBuffer stringBuffer) {
        if (this.tokenStream.pointer < this.patternLength) {
            char c = this.pattern.charAt(this.tokenStream.pointer++);
            this.escapeUtil.escape(string, stringBuffer, c, this.tokenStream.pointer);
        }
    }
}

