/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net.server;

import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.net.server.ClientVisitor;
import ch.qos.logback.core.net.server.RemoteReceiverClient;
import ch.qos.logback.core.net.server.RemoteReceiverServerListener;
import ch.qos.logback.core.net.server.RemoteReceiverServerRunner;
import ch.qos.logback.core.net.server.ServerListener;
import ch.qos.logback.core.net.server.ServerRunner;
import ch.qos.logback.core.spi.PreSerializationTransformer;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.concurrent.Executor;
import javax.net.ServerSocketFactory;

public abstract class AbstractServerSocketAppender<E>
extends AppenderBase<E> {
    public static final int DEFAULT_BACKLOG = 50;
    public static final int DEFAULT_CLIENT_QUEUE_SIZE = 100;
    private int port = 4560;
    private int backlog = 50;
    private int clientQueueSize = 100;
    private String address;
    private ServerRunner<RemoteReceiverClient> runner;

    @Override
    public void start() {
        if (this.isStarted()) {
            return;
        }
        try {
            ServerSocket serverSocket = this.getServerSocketFactory().createServerSocket(this.getPort(), this.getBacklog(), this.getInetAddress());
            ServerListener<RemoteReceiverClient> serverListener = this.createServerListener(serverSocket);
            this.runner = this.createServerRunner(serverListener, this.getContext().getScheduledExecutorService());
            this.runner.setContext(this.getContext());
            this.getContext().getScheduledExecutorService().execute(this.runner);
            super.start();
        }
        catch (Exception exception) {
            this.addError("server startup error: " + exception, exception);
        }
    }

    protected ServerListener<RemoteReceiverClient> createServerListener(ServerSocket serverSocket) {
        return new RemoteReceiverServerListener(serverSocket);
    }

    protected ServerRunner<RemoteReceiverClient> createServerRunner(ServerListener<RemoteReceiverClient> serverListener, Executor executor) {
        return new RemoteReceiverServerRunner(serverListener, executor, this.getClientQueueSize());
    }

    @Override
    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        try {
            this.runner.stop();
            super.stop();
        }
        catch (IOException iOException) {
            this.addError("server shutdown error: " + iOException, iOException);
        }
    }

    @Override
    protected void append(E e) {
        if (e == null) {
            return;
        }
        this.postProcessEvent(e);
        final Serializable serializable = this.getPST().transform(e);
        this.runner.accept(new ClientVisitor<RemoteReceiverClient>(){

            @Override
            public void visit(RemoteReceiverClient remoteReceiverClient) {
                remoteReceiverClient.offer(serializable);
            }
        });
    }

    protected abstract void postProcessEvent(E var1);

    protected abstract PreSerializationTransformer<E> getPST();

    protected ServerSocketFactory getServerSocketFactory() throws Exception {
        return ServerSocketFactory.getDefault();
    }

    protected InetAddress getInetAddress() throws UnknownHostException {
        if (this.getAddress() == null) {
            return null;
        }
        return InetAddress.getByName(this.getAddress());
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int n) {
        this.backlog = n;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String string) {
        this.address = string;
    }

    public int getClientQueueSize() {
        return this.clientQueueSize;
    }

    public void setClientQueueSize(int n) {
        this.clientQueueSize = n;
    }
}

