/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.util;

import ch.qos.logback.core.joran.spi.DefaultClass;
import ch.qos.logback.core.joran.spi.DefaultNestedComponentRegistry;
import ch.qos.logback.core.joran.util.IntrospectionException;
import ch.qos.logback.core.joran.util.Introspector;
import ch.qos.logback.core.joran.util.MethodDescriptor;
import ch.qos.logback.core.joran.util.PropertyDescriptor;
import ch.qos.logback.core.joran.util.StringToObjectConverter;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.AggregationType;
import ch.qos.logback.core.util.PropertySetterException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;

public class PropertySetter
extends ContextAwareBase {
    protected Object obj;
    protected Class<?> objClass;
    protected PropertyDescriptor[] propertyDescriptors;
    protected MethodDescriptor[] methodDescriptors;

    public PropertySetter(Object object) {
        this.obj = object;
        this.objClass = object.getClass();
    }

    protected void introspect() {
        try {
            this.propertyDescriptors = Introspector.getPropertyDescriptors(this.objClass);
            this.methodDescriptors = Introspector.getMethodDescriptors(this.objClass);
        }
        catch (IntrospectionException introspectionException) {
            this.addError("Failed to introspect " + this.obj + ": " + introspectionException.getMessage());
            this.propertyDescriptors = new PropertyDescriptor[0];
            this.methodDescriptors = new MethodDescriptor[0];
        }
    }

    public void setProperty(String string, String string2) {
        if (string2 == null) {
            return;
        }
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(string = Introspector.decapitalize(string));
        if (propertyDescriptor == null) {
            this.addWarn("No such property [" + string + "] in " + this.objClass.getName() + ".");
        } else {
            try {
                this.setProperty(propertyDescriptor, string, string2);
            }
            catch (PropertySetterException propertySetterException) {
                this.addWarn("Failed to set property [" + string + "] to value \"" + string2 + "\". ", propertySetterException);
            }
        }
    }

    public void setProperty(PropertyDescriptor propertyDescriptor, String string, String string2) throws PropertySetterException {
        Object object;
        Method method = propertyDescriptor.getWriteMethod();
        if (method == null) {
            throw new PropertySetterException("No setter for property [" + string + "].");
        }
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length != 1) {
            throw new PropertySetterException("#params for setter != 1");
        }
        try {
            object = StringToObjectConverter.convertArg(this, string2, classArray[0]);
        }
        catch (Throwable throwable) {
            throw new PropertySetterException("Conversion to type [" + classArray[0] + "] failed. ", throwable);
        }
        if (object == null) {
            throw new PropertySetterException("Conversion to type [" + classArray[0] + "] failed.");
        }
        try {
            method.invoke(this.obj, object);
        }
        catch (Exception exception) {
            throw new PropertySetterException(exception);
        }
    }

    public AggregationType computeAggregationType(String string) {
        Object object;
        Method method = this.findAdderMethod(string);
        if (method != null) {
            object = this.computeRawAggregationType(method);
            switch (1.$SwitchMap$ch$qos$logback$core$util$AggregationType[((Enum)object).ordinal()]) {
                case 1: {
                    return AggregationType.NOT_FOUND;
                }
                case 2: {
                    return AggregationType.AS_BASIC_PROPERTY_COLLECTION;
                }
                case 3: {
                    return AggregationType.AS_COMPLEX_PROPERTY_COLLECTION;
                }
                case 4: 
                case 5: {
                    this.addError("Unexpected AggregationType " + object);
                }
            }
        }
        if ((object = this.findSetterMethod(string)) != null) {
            return this.computeRawAggregationType((Method)object);
        }
        return AggregationType.NOT_FOUND;
    }

    private Method findAdderMethod(String string) {
        string = this.capitalizeFirstLetter(string);
        return this.getMethod("add" + string);
    }

    private Method findSetterMethod(String string) {
        String string2 = Introspector.decapitalize(string);
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(string2);
        if (propertyDescriptor != null) {
            return propertyDescriptor.getWriteMethod();
        }
        return null;
    }

    private Class<?> getParameterClassForMethod(Method method) {
        if (method == null) {
            return null;
        }
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length != 1) {
            return null;
        }
        return classArray[0];
    }

    private AggregationType computeRawAggregationType(Method method) {
        Class<?> clazz = this.getParameterClassForMethod(method);
        if (clazz == null) {
            return AggregationType.NOT_FOUND;
        }
        if (StringToObjectConverter.canBeBuiltFromSimpleString(clazz)) {
            return AggregationType.AS_BASIC_PROPERTY;
        }
        return AggregationType.AS_COMPLEX_PROPERTY;
    }

    private boolean isUnequivocallyInstantiable(Class<?> clazz) {
        if (clazz.isInterface()) {
            return false;
        }
        try {
            Object obj = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return obj != null;
        }
        catch (InstantiationException instantiationException) {
            return false;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
    }

    public Class<?> getObjClass() {
        return this.objClass;
    }

    public void addComplexProperty(String string, Object object) {
        Method method = this.findAdderMethod(string);
        if (method != null) {
            Class<?>[] classArray = method.getParameterTypes();
            if (!this.isSanityCheckSuccessful(string, method, classArray, object)) {
                return;
            }
            this.invokeMethodWithSingleParameterOnThisObject(method, object);
        } else {
            this.addError("Could not find method [add" + string + "] in class [" + this.objClass.getName() + "].");
        }
    }

    void invokeMethodWithSingleParameterOnThisObject(Method method, Object object) {
        Class<?> clazz = object.getClass();
        try {
            method.invoke(this.obj, object);
        }
        catch (Exception exception) {
            this.addError("Could not invoke method " + method.getName() + " in class " + this.obj.getClass().getName() + " with parameter of type " + clazz.getName(), exception);
        }
    }

    public void addBasicProperty(String string, String string2) {
        Object object;
        if (string2 == null) {
            return;
        }
        Method method = this.findAdderMethod(string = this.capitalizeFirstLetter(string));
        if (method == null) {
            this.addError("No adder for property [" + string + "].");
            return;
        }
        Class<?>[] classArray = method.getParameterTypes();
        this.isSanityCheckSuccessful(string, method, classArray, string2);
        try {
            object = StringToObjectConverter.convertArg(this, string2, classArray[0]);
        }
        catch (Throwable throwable) {
            this.addError("Conversion to type [" + classArray[0] + "] failed. ", throwable);
            return;
        }
        if (object != null) {
            this.invokeMethodWithSingleParameterOnThisObject(method, string2);
        }
    }

    public void setComplexProperty(String string, Object object) {
        String string2 = Introspector.decapitalize(string);
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(string2);
        if (propertyDescriptor == null) {
            this.addWarn("Could not find PropertyDescriptor for [" + string + "] in " + this.objClass.getName());
            return;
        }
        Method method = propertyDescriptor.getWriteMethod();
        if (method == null) {
            this.addWarn("Not setter method for property [" + string + "] in " + this.obj.getClass().getName());
            return;
        }
        Class<?>[] classArray = method.getParameterTypes();
        if (!this.isSanityCheckSuccessful(string, method, classArray, object)) {
            return;
        }
        try {
            this.invokeMethodWithSingleParameterOnThisObject(method, object);
        }
        catch (Exception exception) {
            this.addError("Could not set component " + this.obj + " for parent component " + this.obj, exception);
        }
    }

    private boolean isSanityCheckSuccessful(String string, Method method, Class<?>[] classArray, Object object) {
        Class<?> clazz = object.getClass();
        if (classArray.length != 1) {
            this.addError("Wrong number of parameters in setter method for property [" + string + "] in " + this.obj.getClass().getName());
            return false;
        }
        if (!classArray[0].isAssignableFrom(object.getClass())) {
            this.addError("A \"" + clazz.getName() + "\" object is not assignable to a \"" + classArray[0].getName() + "\" variable.");
            this.addError("The class \"" + classArray[0].getName() + "\" was loaded by ");
            this.addError("[" + classArray[0].getClassLoader() + "] whereas object of type ");
            this.addError("\"" + clazz.getName() + "\" was loaded by [" + clazz.getClassLoader() + "].");
            return false;
        }
        return true;
    }

    private String capitalizeFirstLetter(String string) {
        return string.substring(0, 1).toUpperCase(Locale.US) + string.substring(1);
    }

    protected Method getMethod(String string) {
        if (this.methodDescriptors == null) {
            this.introspect();
        }
        for (int i = 0; i < this.methodDescriptors.length; ++i) {
            if (!string.equals(this.methodDescriptors[i].getName())) continue;
            return this.methodDescriptors[i].getMethod();
        }
        return null;
    }

    protected PropertyDescriptor getPropertyDescriptor(String string) {
        if (this.propertyDescriptors == null) {
            this.introspect();
        }
        for (int i = 0; i < this.propertyDescriptors.length; ++i) {
            if (!string.equals(this.propertyDescriptors[i].getName())) continue;
            return this.propertyDescriptors[i];
        }
        return null;
    }

    public Object getObj() {
        return this.obj;
    }

    Method getRelevantMethod(String string, AggregationType aggregationType) {
        Method method;
        String string2 = this.capitalizeFirstLetter(string);
        if (aggregationType == AggregationType.AS_COMPLEX_PROPERTY_COLLECTION) {
            method = this.findAdderMethod(string2);
        } else if (aggregationType == AggregationType.AS_COMPLEX_PROPERTY) {
            method = this.findSetterMethod(string2);
        } else {
            throw new IllegalStateException((Object)((Object)aggregationType) + " not allowed here");
        }
        return method;
    }

    <T extends Annotation> T getAnnotation(String string, Class<T> clazz, Method method) {
        if (method != null) {
            return method.getAnnotation(clazz);
        }
        return null;
    }

    Class<?> getDefaultClassNameByAnnonation(String string, Method method) {
        DefaultClass defaultClass = this.getAnnotation(string, DefaultClass.class, method);
        if (defaultClass != null) {
            return defaultClass.value();
        }
        return null;
    }

    Class<?> getByConcreteType(String string, Method method) {
        Class<?> clazz = this.getParameterClassForMethod(method);
        if (clazz == null) {
            return null;
        }
        boolean bl = this.isUnequivocallyInstantiable(clazz);
        if (bl) {
            return clazz;
        }
        return null;
    }

    public Class<?> getClassNameViaImplicitRules(String string, AggregationType aggregationType, DefaultNestedComponentRegistry defaultNestedComponentRegistry) {
        Class<?> clazz = defaultNestedComponentRegistry.findDefaultComponentType(this.obj.getClass(), string);
        if (clazz != null) {
            return clazz;
        }
        Method method = this.getRelevantMethod(string, aggregationType);
        if (method == null) {
            return null;
        }
        Class<?> clazz2 = this.getDefaultClassNameByAnnonation(string, method);
        if (clazz2 != null) {
            return clazz2;
        }
        return this.getByConcreteType(string, method);
    }
}

