/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.hook.DefaultShutdownHook;
import ch.qos.logback.core.hook.ShutdownHookBase;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.util.OptionHelper;
import org.xml.sax.Attributes;

public class ShutdownHookAction
extends Action {
    ShutdownHookBase hook;
    private boolean inError;

    @Override
    public void begin(InterpretationContext interpretationContext, String string, Attributes attributes) throws ActionException {
        this.hook = null;
        this.inError = false;
        String string2 = attributes.getValue("class");
        if (OptionHelper.isEmpty(string2)) {
            string2 = DefaultShutdownHook.class.getName();
            this.addInfo("Assuming className [" + string2 + "]");
        }
        try {
            this.addInfo("About to instantiate shutdown hook of type [" + string2 + "]");
            this.hook = (ShutdownHookBase)OptionHelper.instantiateByClassName(string2, ShutdownHookBase.class, this.context);
            this.hook.setContext(this.context);
            interpretationContext.pushObject(this.hook);
        }
        catch (Exception exception) {
            this.inError = true;
            this.addError("Could not create a shutdown hook of type [" + string2 + "].", exception);
            throw new ActionException(exception);
        }
    }

    @Override
    public void end(InterpretationContext interpretationContext, String string) throws ActionException {
        if (this.inError) {
            return;
        }
        Object object = interpretationContext.peekObject();
        if (object != this.hook) {
            this.addWarn("The object at the of the stack is not the hook pushed earlier.");
        } else {
            interpretationContext.popObject();
            Thread thread = new Thread((Runnable)this.hook, "Logback shutdown hook [" + this.context.getName() + "]");
            this.addInfo("Registering shutdown hook with JVM runtime");
            this.context.putObject("SHUTDOWN_HOOK", thread);
            Runtime.getRuntime().addShutdownHook(thread);
        }
    }
}

