/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import org.xml.sax.Attributes;

public abstract class AbstractIncludeAction
extends Action {
    private static final String FILE_ATTR = "file";
    private static final String URL_ATTR = "url";
    private static final String RESOURCE_ATTR = "resource";
    private static final String OPTIONAL_ATTR = "optional";
    private String attributeInUse;
    private boolean optional;

    protected abstract void processInclude(InterpretationContext var1, URL var2) throws JoranException;

    protected void handleError(String string, Exception exception) {
        if (exception != null && (exception instanceof FileNotFoundException || exception instanceof UnknownHostException)) {
            this.addWarn(string, exception);
        } else {
            this.addError(string, exception);
        }
    }

    @Override
    public void begin(InterpretationContext interpretationContext, String string, Attributes attributes) throws ActionException {
        this.attributeInUse = null;
        this.optional = OptionHelper.toBoolean(attributes.getValue(OPTIONAL_ATTR), false);
        if (!this.checkAttributes(attributes)) {
            return;
        }
        try {
            URL uRL = this.getInputURL(interpretationContext, attributes);
            if (uRL != null) {
                this.processInclude(interpretationContext, uRL);
            }
        }
        catch (JoranException joranException) {
            this.optionalWarning("Error while parsing " + this.attributeInUse, joranException);
        }
    }

    protected void close(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean checkAttributes(Attributes attributes) {
        String string = attributes.getValue(FILE_ATTR);
        String string2 = attributes.getValue(URL_ATTR);
        String string3 = attributes.getValue(RESOURCE_ATTR);
        int n = 0;
        if (!OptionHelper.isEmpty(string)) {
            ++n;
        }
        if (!OptionHelper.isEmpty(string2)) {
            ++n;
        }
        if (!OptionHelper.isEmpty(string3)) {
            ++n;
        }
        if (n == 0) {
            this.optionalWarning(String.format("One of \"%1$s\", \"%2$s\" or \"%3$s\" attributes must be set.", FILE_ATTR, RESOURCE_ATTR, URL_ATTR), null);
            return false;
        }
        if (n > 1) {
            this.optionalWarning(String.format("Only one of \"%1$s\", \"%2$s\" or \"%3$s\" attributes should be set.", FILE_ATTR, RESOURCE_ATTR, URL_ATTR), null);
            return false;
        }
        if (n == 1) {
            return true;
        }
        throw new IllegalStateException("Count value [" + n + "] is not expected");
    }

    private URL attributeToURL(String string) {
        try {
            URL uRL = new URL(string);
            InputStream inputStream = uRL.openStream();
            inputStream.close();
            inputStream = null;
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            this.optionalWarning("URL [" + string + "] is not well formed.", malformedURLException);
        }
        catch (IOException iOException) {
            this.optionalWarning("URL [" + string + "] cannot be opened.", iOException);
        }
        return null;
    }

    private URL resourceAsURL(String string) {
        URL uRL = Loader.getResourceBySelfClassLoader(string);
        if (uRL == null) {
            this.optionalWarning("Could not find resource corresponding to [" + string + "]", null);
            return null;
        }
        return uRL;
    }

    private URL filePathAsURL(String string) {
        File file = new File(string);
        if (!file.exists() || !file.isFile()) {
            this.optionalWarning("File does not exist [" + string + "]", new FileNotFoundException(string));
            return null;
        }
        URI uRI = file.toURI();
        try {
            return uRI.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    protected String getAttributeInUse() {
        return this.attributeInUse;
    }

    protected boolean isOptional() {
        return this.optional;
    }

    private URL getInputURL(InterpretationContext interpretationContext, Attributes attributes) {
        String string = attributes.getValue(FILE_ATTR);
        String string2 = attributes.getValue(URL_ATTR);
        String string3 = attributes.getValue(RESOURCE_ATTR);
        if (!OptionHelper.isEmpty(string)) {
            this.attributeInUse = interpretationContext.subst(string);
            return this.filePathAsURL(this.attributeInUse);
        }
        if (!OptionHelper.isEmpty(string2)) {
            this.attributeInUse = interpretationContext.subst(string2);
            return this.attributeToURL(this.attributeInUse);
        }
        if (!OptionHelper.isEmpty(string3)) {
            this.attributeInUse = interpretationContext.subst(string3);
            return this.resourceAsURL(this.attributeInUse);
        }
        throw new IllegalStateException("A URL stream should have been returned");
    }

    @Override
    public void end(InterpretationContext interpretationContext, String string) throws ActionException {
    }

    protected void optionalWarning(String string, Exception exception) {
        if (!this.isOptional()) {
            this.handleError(string, exception);
        }
    }
}

