/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.helpers;

import java.util.ArrayList;
import java.util.List;

public class CyclicBuffer<E> {
    E[] ea;
    int first;
    int last;
    int numElems;
    int maxSize;

    public CyclicBuffer(int n) throws IllegalArgumentException {
        if (n < 1) {
            throw new IllegalArgumentException("The maxSize argument (" + n + ") is not a positive integer.");
        }
        this.init(n);
    }

    public CyclicBuffer(CyclicBuffer<E> cyclicBuffer) {
        this.maxSize = cyclicBuffer.maxSize;
        this.ea = new Object[this.maxSize];
        System.arraycopy(cyclicBuffer.ea, 0, this.ea, 0, this.maxSize);
        this.last = cyclicBuffer.last;
        this.first = cyclicBuffer.first;
        this.numElems = cyclicBuffer.numElems;
    }

    private void init(int n) {
        this.maxSize = n;
        this.ea = new Object[n];
        this.first = 0;
        this.last = 0;
        this.numElems = 0;
    }

    public void clear() {
        this.init(this.maxSize);
    }

    public void add(E e) {
        this.ea[this.last] = e;
        if (++this.last == this.maxSize) {
            this.last = 0;
        }
        if (this.numElems < this.maxSize) {
            ++this.numElems;
        } else if (++this.first == this.maxSize) {
            this.first = 0;
        }
    }

    public E get(int n) {
        if (n < 0 || n >= this.numElems) {
            return null;
        }
        return this.ea[(this.first + n) % this.maxSize];
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public E get() {
        E e = null;
        if (this.numElems > 0) {
            --this.numElems;
            e = this.ea[this.first];
            this.ea[this.first] = null;
            if (++this.first == this.maxSize) {
                this.first = 0;
            }
        }
        return e;
    }

    public List<E> asList() {
        ArrayList<E> arrayList = new ArrayList<E>();
        for (int i = 0; i < this.length(); ++i) {
            arrayList.add(this.get(i));
        }
        return arrayList;
    }

    public int length() {
        return this.numElems;
    }

    public void resize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative array size [" + n + "] not allowed.");
        }
        if (n == this.numElems) {
            return;
        }
        Object[] objectArray = new Object[n];
        int n2 = n < this.numElems ? n : this.numElems;
        for (int i = 0; i < n2; ++i) {
            objectArray[i] = this.ea[this.first];
            this.ea[this.first] = null;
            if (++this.first != this.numElems) continue;
            this.first = 0;
        }
        this.ea = objectArray;
        this.first = 0;
        this.numElems = n2;
        this.maxSize = n;
        this.last = n2 == n ? 0 : n2;
    }
}

