/**
 * Copyright 2019 Anthony Trinh
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ch.qos.logback.classic.spi;

import java.io.Serializable;
import java.util.Comparator;

import ch.qos.logback.classic.Logger;

public class LoggerComparator implements Comparator<Logger>, Serializable {

  private static final long serialVersionUID = 1L;

  public int compare(Logger l1, Logger l2) {
    if (l1.getName().equals(l2.getName())) {
      return 0;
    }
    if (l1.getName().equals(Logger.ROOT_LOGGER_NAME)) {
      return -1;
    }
    if (l2.getName().equals(Logger.ROOT_LOGGER_NAME)) {
      return 1;
    }
    return l1.getName().compareTo(l2.getName());
  }

}
