/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.helper.ArchiveRemover;
import ch.qos.logback.core.rolling.helper.DateParser;
import ch.qos.logback.core.rolling.helper.FileFinder;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import ch.qos.logback.core.rolling.helper.FileProvider;
import ch.qos.logback.core.rolling.helper.FileSorter;
import ch.qos.logback.core.rolling.helper.IntParser;
import ch.qos.logback.core.rolling.helper.RollingCalendar;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.FileSize;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeBasedArchiveRemover
extends ContextAwareBase
implements ArchiveRemover {
    protected final FileNamePattern fileNamePattern;
    private final RollingCalendar rc;
    private int maxHistory = 0;
    private long totalSizeCap = 0L;
    private final FileProvider fileProvider;
    private final FileSorter fileSorter;
    private final DateParser dateParser;

    public TimeBasedArchiveRemover(FileNamePattern fileNamePattern, RollingCalendar rollingCalendar, FileProvider fileProvider) {
        this.fileNamePattern = fileNamePattern;
        this.rc = rollingCalendar;
        this.fileProvider = fileProvider;
        this.dateParser = new DateParser(fileNamePattern);
        this.fileSorter = new FileSorter(this.dateParser, new IntParser(fileNamePattern));
    }

    @Override
    public void clean(Date date) {
        List<String> list = this.findFiles();
        List<String> list2 = this.filterFiles(list, this.createExpiredFileFilter(date));
        for (String object2 : list2) {
            this.delete(new File(object2));
        }
        if (this.totalSizeCap != 0L && this.totalSizeCap > 0L) {
            this.capTotalSize(list);
        }
        List<String> list3 = this.findEmptyDirs();
        Iterator iterator = list3.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.delete(new File(string));
        }
    }

    private boolean delete(File file) {
        this.addInfo("deleting " + file);
        boolean bl = this.fileProvider.deleteFile(file);
        if (!bl) {
            this.addWarn("cannot delete " + file);
        }
        return bl;
    }

    private void capTotalSize(List<String> list) {
        long l = 0L;
        long l2 = 0L;
        String[] stringArray = list.toArray(new String[0]);
        this.fileSorter.sort(stringArray);
        for (String string : stringArray) {
            File file = new File(string);
            long l3 = this.fileProvider.length(file);
            if (l + l3 > this.totalSizeCap) {
                this.addInfo("Deleting [" + file + "] of size " + new FileSize(l3));
                if (!this.delete(file)) {
                    l3 = 0L;
                }
                l2 += l3;
            }
            l += l3;
        }
        this.addInfo("Removed  " + new FileSize(l2) + " of files");
    }

    @Override
    public void setMaxHistory(int n) {
        this.maxHistory = n;
    }

    @Override
    public void setTotalSizeCap(long l) {
        this.totalSizeCap = l;
    }

    public String toString() {
        return "c.q.l.core.rolling.helper.TimeBasedArchiveRemover";
    }

    @Override
    public Future<?> cleanAsynchronously(Date date) {
        ArchiveRemoverRunnable archiveRemoverRunnable = new ArchiveRemoverRunnable(date);
        ScheduledExecutorService scheduledExecutorService = this.context.getScheduledExecutorService();
        return scheduledExecutorService.submit(archiveRemoverRunnable);
    }

    private FilenameFilter createExpiredFileFilter(final Date date) {
        return new FilenameFilter(){

            public boolean accept(File file, String string) {
                Date date3 = TimeBasedArchiveRemover.this.dateParser.parseFilename(string);
                date3 = TimeBasedArchiveRemover.this.rc.normalizeDate(date3);
                Date date2 = TimeBasedArchiveRemover.this.rc.getEndOfNextNthPeriod(date, -TimeBasedArchiveRemover.this.maxHistory);
                date2 = TimeBasedArchiveRemover.this.rc.normalizeDate(date2);
                return date3.compareTo(date2) < 0;
            }
        };
    }

    private List<String> filterFiles(List<String> list, FilenameFilter filenameFilter) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list.toArray(new String[0])) {
            if (!filenameFilter.accept(null, string)) continue;
            arrayList.add(string);
            list.remove(string);
        }
        return arrayList;
    }

    private List<String> findFiles() {
        return new FileFinder(this.fileProvider).findFiles(this.fileNamePattern.toRegex());
    }

    private List<String> findEmptyDirs() {
        List<String> list = new FileFinder(this.fileProvider).findDirs(this.fileNamePattern.toRegex());
        Collections.reverse(list);
        ArrayDeque<String> arrayDeque = new ArrayDeque<String>();
        for (String string : list) {
            int n = this.fileProvider.list(new File(string), null).length;
            if (n != 0 && (n != 1 || arrayDeque.size() <= 0 || !string.equals(arrayDeque.peekLast()))) continue;
            arrayDeque.add(string);
        }
        return Arrays.asList(arrayDeque.toArray(new String[0]));
    }

    private class ArchiveRemoverRunnable
    implements Runnable {
        Date now;

        ArchiveRemoverRunnable(Date date) {
            this.now = date;
        }

        public void run() {
            TimeBasedArchiveRemover.this.clean(this.now);
        }
    }
}

