/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.layout;

import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.LayoutBase;
import ch.qos.logback.core.util.CachingDateFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TTLLLayout
extends LayoutBase<ILoggingEvent> {
    CachingDateFormatter cachingDateFormatter = new CachingDateFormatter("HH:mm:ss.SSS");
    ThrowableProxyConverter tpc = new ThrowableProxyConverter();

    @Override
    public void start() {
        this.tpc.start();
        super.start();
    }

    @Override
    public String doLayout(ILoggingEvent iLoggingEvent) {
        if (!this.isStarted()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        long l = iLoggingEvent.getTimeStamp();
        stringBuilder.append(this.cachingDateFormatter.format(l));
        stringBuilder.append(" [");
        stringBuilder.append(iLoggingEvent.getThreadName());
        stringBuilder.append("] ");
        stringBuilder.append(iLoggingEvent.getLevel().toString());
        stringBuilder.append(" ");
        stringBuilder.append(iLoggingEvent.getLoggerName());
        stringBuilder.append(" - ");
        stringBuilder.append(iLoggingEvent.getFormattedMessage());
        stringBuilder.append(CoreConstants.LINE_SEPARATOR);
        IThrowableProxy iThrowableProxy = iLoggingEvent.getThrowableProxy();
        if (iThrowableProxy != null) {
            String string = this.tpc.convert(iLoggingEvent);
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }
}

