/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.joran.spi.NoAutoStart;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicyBase;
import ch.qos.logback.core.rolling.helper.ArchiveRemover;
import ch.qos.logback.core.rolling.helper.CompressionMode;
import ch.qos.logback.core.rolling.helper.FileFilterUtil;
import ch.qos.logback.core.rolling.helper.SizeAndTimeBasedArchiveRemover;
import ch.qos.logback.core.util.FileSize;
import java.io.File;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NoAutoStart
public class SizeAndTimeBasedFNATP<E>
extends TimeBasedFileNamingAndTriggeringPolicyBase<E> {
    int currentPeriodsCounter = 0;
    FileSize maxFileSize;
    String maxFileSizeAsString;
    static String MISSING_INT_TOKEN = "Missing integer token, that is %i, in FileNamePattern [";
    static String MISSING_DATE_TOKEN = "Missing date token, that is %d, in FileNamePattern [";
    private int invocationCounter;
    private int invocationMask = 1;

    @Override
    public void start() {
        super.start();
        if (!super.isErrorFree()) {
            return;
        }
        if (!this.validDateAndIntegerTokens()) {
            this.started = false;
            return;
        }
        this.archiveRemover = this.createArchiveRemover();
        this.archiveRemover.setContext(this.context);
        String string = this.tbrp.fileNamePattern.toRegexForFixedDate(this.dateInCurrentPeriod);
        String string2 = FileFilterUtil.afterLastSlash(string);
        this.computeCurrentPeriodsHighestCounterValue(string2);
        this.started = true;
    }

    private boolean validDateAndIntegerTokens() {
        boolean bl = false;
        if (this.tbrp.fileNamePattern.getIntegerTokenConverter() == null) {
            bl = true;
            this.addError(MISSING_INT_TOKEN + this.tbrp.fileNamePatternStr + "]");
            this.addError("See also http://logback.qos.ch/codes.html#sat_missing_integer_token");
        }
        if (this.tbrp.fileNamePattern.getPrimaryDateTokenConverter() == null) {
            bl = true;
            this.addError(MISSING_DATE_TOKEN + this.tbrp.fileNamePatternStr + "]");
        }
        return !bl;
    }

    protected ArchiveRemover createArchiveRemover() {
        return new SizeAndTimeBasedArchiveRemover(this.tbrp.fileNamePattern, this.rc);
    }

    void computeCurrentPeriodsHighestCounterValue(String string) {
        File file = new File(this.getCurrentPeriodsFileNameWithoutCompressionSuffix());
        File file2 = file.getParentFile();
        File[] fileArray = FileFilterUtil.filesInFolderMatchingStemRegex(file2, string);
        if (fileArray == null || fileArray.length == 0) {
            this.currentPeriodsCounter = 0;
            return;
        }
        this.currentPeriodsCounter = FileFilterUtil.findHighestCounter(fileArray, string);
        if (this.tbrp.getParentsRawFileProperty() != null || this.tbrp.compressionMode != CompressionMode.NONE) {
            ++this.currentPeriodsCounter;
        }
    }

    @Override
    public boolean isTriggeringEvent(File file, E e) {
        long l = this.getCurrentTime();
        if (l >= this.nextCheck) {
            Date date = this.dateInCurrentPeriod;
            this.elapsedPeriodsFileName = this.tbrp.fileNamePatternWCS.convertMultipleArguments(date, this.currentPeriodsCounter);
            this.currentPeriodsCounter = 0;
            this.setDateInCurrentPeriod(l);
            this.computeNextCheck();
            return true;
        }
        if ((++this.invocationCounter & this.invocationMask) != this.invocationMask) {
            return false;
        }
        if (this.invocationMask < 15) {
            this.invocationMask = (this.invocationMask << 1) + 1;
        }
        if (file.length() >= this.maxFileSize.getSize()) {
            this.elapsedPeriodsFileName = this.tbrp.fileNamePatternWCS.convertMultipleArguments(this.dateInCurrentPeriod, this.currentPeriodsCounter);
            ++this.currentPeriodsCounter;
            return true;
        }
        return false;
    }

    @Override
    public String getCurrentPeriodsFileNameWithoutCompressionSuffix() {
        return this.tbrp.fileNamePatternWCS.convertMultipleArguments(this.dateInCurrentPeriod, this.currentPeriodsCounter);
    }

    public String getMaxFileSize() {
        return this.maxFileSizeAsString;
    }

    public void setMaxFileSize(String string) {
        this.maxFileSizeAsString = string;
        this.maxFileSize = FileSize.valueOf(string);
    }
}

