/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.android;

import java.lang.reflect.Method;

public class SystemPropertiesProxy {
    private static final SystemPropertiesProxy SINGLETON = new SystemPropertiesProxy(null);
    private Class<?> SystemProperties;
    private Method getString;
    private Method getBoolean;

    private SystemPropertiesProxy(ClassLoader classLoader) {
        try {
            this.setClassLoader(classLoader);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static SystemPropertiesProxy getInstance() {
        return SINGLETON;
    }

    public void setClassLoader(ClassLoader classLoader) throws ClassNotFoundException, SecurityException, NoSuchMethodException {
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        this.SystemProperties = classLoader.loadClass("android.os.SystemProperties");
        this.getString = this.SystemProperties.getMethod("get", String.class, String.class);
        this.getBoolean = this.SystemProperties.getMethod("getBoolean", String.class, Boolean.TYPE);
    }

    public String get(String string, String string2) throws IllegalArgumentException {
        if (this.SystemProperties == null || this.getString == null) {
            return null;
        }
        String string3 = null;
        try {
            string3 = (String)this.getString.invoke(this.SystemProperties, string, string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string3 == null || string3.length() == 0) {
            string3 = string2;
        }
        return string3;
    }

    public Boolean getBoolean(String string, boolean bl) throws IllegalArgumentException {
        if (this.SystemProperties == null || this.getBoolean == null) {
            return bl;
        }
        Boolean bl2 = bl;
        try {
            bl2 = (Boolean)this.getBoolean.invoke(this.SystemProperties, string, bl);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl2;
    }
}

