/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.util.LoggerNameUtil;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.spi.AppenderAttachable;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import ch.qos.logback.core.spi.FilterReply;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.spi.LocationAwareLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Logger
implements org.slf4j.Logger,
LocationAwareLogger,
AppenderAttachable<ILoggingEvent>,
Serializable {
    private static final long serialVersionUID = 5454405123156820674L;
    public static final String FQCN = Logger.class.getName();
    private String name;
    private transient Level level;
    private transient int effectiveLevelInt;
    private transient Logger parent;
    private transient List<Logger> childrenList;
    private transient AppenderAttachableImpl<ILoggingEvent> aai;
    private transient boolean additive = true;
    final transient LoggerContext loggerContext;
    private static final int DEFAULT_CHILD_ARRAY_SIZE = 5;

    Logger(String string, Logger logger, LoggerContext loggerContext) {
        this.name = string;
        this.parent = logger;
        this.loggerContext = loggerContext;
    }

    public Level getEffectiveLevel() {
        return Level.toLevel(this.effectiveLevelInt);
    }

    int getEffectiveLevelInt() {
        return this.effectiveLevelInt;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getName() {
        return this.name;
    }

    private boolean isRootLogger() {
        return this.parent == null;
    }

    Logger getChildByName(String string) {
        if (this.childrenList == null) {
            return null;
        }
        int n = this.childrenList.size();
        for (int i = 0; i < n; ++i) {
            Logger logger = this.childrenList.get(i);
            String string2 = logger.getName();
            if (!string.equals(string2)) continue;
            return logger;
        }
        return null;
    }

    public synchronized void setLevel(Level level) {
        if (this.level == level) {
            return;
        }
        if (level == null && this.isRootLogger()) {
            throw new IllegalArgumentException("The level of the root logger cannot be set to null");
        }
        this.level = level;
        if (level == null) {
            this.effectiveLevelInt = this.parent.effectiveLevelInt;
            level = this.parent.getEffectiveLevel();
        } else {
            this.effectiveLevelInt = level.levelInt;
        }
        if (this.childrenList != null) {
            int n = this.childrenList.size();
            for (int i = 0; i < n; ++i) {
                Logger logger = this.childrenList.get(i);
                logger.handleParentLevelChange(this.effectiveLevelInt);
            }
        }
        this.loggerContext.fireOnLevelChange(this, level);
    }

    private synchronized void handleParentLevelChange(int n) {
        if (this.level == null) {
            this.effectiveLevelInt = n;
            if (this.childrenList != null) {
                int n2 = this.childrenList.size();
                for (int i = 0; i < n2; ++i) {
                    Logger logger = this.childrenList.get(i);
                    logger.handleParentLevelChange(n);
                }
            }
        }
    }

    @Override
    public void detachAndStopAllAppenders() {
        if (this.aai != null) {
            this.aai.detachAndStopAllAppenders();
        }
    }

    @Override
    public boolean detachAppender(String string) {
        if (this.aai == null) {
            return false;
        }
        return this.aai.detachAppender(string);
    }

    @Override
    public synchronized void addAppender(Appender<ILoggingEvent> appender) {
        if (this.aai == null) {
            this.aai = new AppenderAttachableImpl();
        }
        this.aai.addAppender(appender);
    }

    @Override
    public boolean isAttached(Appender<ILoggingEvent> appender) {
        if (this.aai == null) {
            return false;
        }
        return this.aai.isAttached(appender);
    }

    @Override
    public Iterator<Appender<ILoggingEvent>> iteratorForAppenders() {
        if (this.aai == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.aai.iteratorForAppenders();
    }

    @Override
    public Appender<ILoggingEvent> getAppender(String string) {
        if (this.aai == null) {
            return null;
        }
        return this.aai.getAppender(string);
    }

    public void callAppenders(ILoggingEvent iLoggingEvent) {
        int n = 0;
        Logger logger = this;
        while (logger != null) {
            n += logger.appendLoopOnAppenders(iLoggingEvent);
            if (!logger.additive) break;
            logger = logger.parent;
        }
        if (n == 0) {
            this.loggerContext.noAppenderDefinedWarning(this);
        }
    }

    private int appendLoopOnAppenders(ILoggingEvent iLoggingEvent) {
        if (this.aai != null) {
            return this.aai.appendLoopOnAppenders(iLoggingEvent);
        }
        return 0;
    }

    @Override
    public boolean detachAppender(Appender<ILoggingEvent> appender) {
        if (this.aai == null) {
            return false;
        }
        return this.aai.detachAppender(appender);
    }

    Logger createChildByLastNamePart(String string) {
        int n = LoggerNameUtil.getFirstSeparatorIndexOf(string);
        if (n != -1) {
            throw new IllegalArgumentException("Child name [" + string + " passed as parameter, may not include [" + '.' + "]");
        }
        if (this.childrenList == null) {
            this.childrenList = new ArrayList<Logger>();
        }
        Logger logger = this.isRootLogger() ? new Logger(string, this, this.loggerContext) : new Logger(this.name + '.' + string, this, this.loggerContext);
        this.childrenList.add(logger);
        logger.effectiveLevelInt = this.effectiveLevelInt;
        return logger;
    }

    private void localLevelReset() {
        this.effectiveLevelInt = 10000;
        this.level = this.isRootLogger() ? Level.DEBUG : null;
    }

    void recursiveReset() {
        this.detachAndStopAllAppenders();
        this.localLevelReset();
        this.additive = true;
        if (this.childrenList == null) {
            return;
        }
        for (Logger logger : new CopyOnWriteArrayList<Logger>(this.childrenList)) {
            logger.recursiveReset();
        }
    }

    Logger createChildByName(String string) {
        int n = LoggerNameUtil.getSeparatorIndexOf(string, this.name.length() + 1);
        if (n != -1) {
            throw new IllegalArgumentException("For logger [" + this.name + "] child name [" + string + " passed as parameter, may not include '.' after index" + (this.name.length() + 1));
        }
        if (this.childrenList == null) {
            this.childrenList = new ArrayList<Logger>(5);
        }
        Logger logger = new Logger(string, this, this.loggerContext);
        this.childrenList.add(logger);
        logger.effectiveLevelInt = this.effectiveLevelInt;
        return logger;
    }

    private void filterAndLog_0_Or3Plus(String string, Marker marker, Level level, String string2, Object[] objectArray, Throwable throwable) {
        FilterReply filterReply = this.loggerContext.getTurboFilterChainDecision_0_3OrMore(marker, this, level, string2, objectArray, throwable);
        if (filterReply == FilterReply.NEUTRAL ? this.effectiveLevelInt > level.levelInt : filterReply == FilterReply.DENY) {
            return;
        }
        this.buildLoggingEventAndAppend(string, marker, level, string2, objectArray, throwable);
    }

    private void filterAndLog_1(String string, Marker marker, Level level, String string2, Object object, Throwable throwable) {
        FilterReply filterReply = this.loggerContext.getTurboFilterChainDecision_1(marker, this, level, string2, object, throwable);
        if (filterReply == FilterReply.NEUTRAL ? this.effectiveLevelInt > level.levelInt : filterReply == FilterReply.DENY) {
            return;
        }
        this.buildLoggingEventAndAppend(string, marker, level, string2, new Object[]{object}, throwable);
    }

    private void filterAndLog_2(String string, Marker marker, Level level, String string2, Object object, Object object2, Throwable throwable) {
        FilterReply filterReply = this.loggerContext.getTurboFilterChainDecision_2(marker, this, level, string2, object, object2, throwable);
        if (filterReply == FilterReply.NEUTRAL ? this.effectiveLevelInt > level.levelInt : filterReply == FilterReply.DENY) {
            return;
        }
        this.buildLoggingEventAndAppend(string, marker, level, string2, new Object[]{object, object2}, throwable);
    }

    private void buildLoggingEventAndAppend(String string, Marker marker, Level level, String string2, Object[] objectArray, Throwable throwable) {
        LoggingEvent loggingEvent = new LoggingEvent(string, this, level, string2, throwable, objectArray);
        loggingEvent.setMarker(marker);
        this.callAppenders(loggingEvent);
    }

    public void trace(String string) {
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.TRACE, string, null, null);
    }

    public void trace(String string, Object object) {
        this.filterAndLog_1(FQCN, null, Level.TRACE, string, object, null);
    }

    public void trace(String string, Object object, Object object2) {
        this.filterAndLog_2(FQCN, null, Level.TRACE, string, object, object2, null);
    }

    public void trace(String string, Object ... objectArray) {
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.TRACE, string, objectArray, null);
    }

    public void trace(String string, Throwable throwable) {
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.TRACE, string, null, throwable);
    }

    public void trace(Marker marker, String string) {
        this.filterAndLog_0_Or3Plus(FQCN, marker, Level.TRACE, string, null, null);
    }

    public void trace(Marker marker, String string, Object object) {
        this.filterAndLog_1(FQCN, marker, Level.TRACE, string, object, null);
    }

    public void trace(Marker marker, String string, Object object, Object object2) {
        this.filterAndLog_2(FQCN, marker, Level.TRACE, string, object, object2, null);
    }

    public void trace(Marker marker, String string, Object ... objectArray) {
        this.filterAndLog_0_Or3Plus(FQCN, marker, Level.TRACE, string, objectArray, null);
    }

    public void trace(Marker marker, String string, Throwable throwable) {
        this.filterAndLog_0_Or3Plus(FQCN, marker, Level.TRACE, string, null, throwable);
    }

    public boolean isDebugEnabled() {
        return this.isDebugEnabled(null);
    }

    public boolean isDebugEnabled(Marker marker) {
        FilterReply filterReply = this.callTurboFilters(marker, Level.DEBUG);
        if (filterReply == FilterReply.NEUTRAL) {
            return this.effectiveLevelInt <= 10000;
        }
        if (filterReply == FilterReply.DENY) {
            return false;
        }
        if (filterReply == FilterReply.ACCEPT) {
            return true;
        }
        throw new IllegalStateException("Unknown FilterReply value: " + (Object)((Object)filterReply));
    }

    public void debug(String string) {
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.DEBUG, string, null, null);
    }

    public void debug(String string, Object object) {
        this.filterAndLog_1(FQCN, null, Level.DEBUG, string, object, null);
    }

    public void debug(String string, Object object, Object object2) {
        this.filterAndLog_2(FQCN, null, Level.DEBUG, string, object, object2, null);
    }

    public void debug(String string, Object ... objectArray) {
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.DEBUG, string, objectArray, null);
    }

    public void debug(String string, Throwable throwable) {
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.DEBUG, string, null, throwable);
    }

    public void debug(Marker marker, String string) {
        this.filterAndLog_0_Or3Plus(FQCN, marker, Level.DEBUG, string, null, null);
    }

    public void debug(Marker marker, String string, Object object) {
        this.filterAndLog_1(FQCN, marker, Level.DEBUG, string, object, null);
    }

    public void debug(Marker marker, String string, Object object, Object object2) {
        this.filterAndLog_2(FQCN, marker, Level.DEBUG, string, object, object2, null);
    }

    public void debug(Marker marker, String string, Object ... objectArray) {
        this.filterAndLog_0_Or3Plus(FQCN, marker, Level.DEBUG, string, objectArray, null);
    }

    public void debug(Marker marker, String string, Throwable throwable) {
        this.filterAndLog_0_Or3Plus(FQCN, marker, Level.DEBUG, string, null, throwable);
    }

    public void error(String string) {
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.ERROR, string, null, null);
    }

    public void error(String string, Object object) {
        this.filterAndLog_1(FQCN, null, Level.ERROR, string, object, null);
    }

    public void error(String string, Object object, Object object2) {
        this.filterAndLog_2(FQCN, null, Level.ERROR, string, object, object2, null);
    }

    public void error(String string, Object ... objectArray) {
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.ERROR, string, objectArray, null);
    }

    public void error(String string, Throwable throwable) {
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.ERROR, string, null, throwable);
    }

    public void error(Marker marker, String string) {
        this.filterAndLog_0_Or3Plus(FQCN, marker, Level.ERROR, string, null, null);
    }

    public void error(Marker marker, String string, Object object) {
        this.filterAndLog_1(FQCN, marker, Level.ERROR, string, object, null);
    }

    public void error(Marker marker, String string, Object object, Object object2) {
        this.filterAndLog_2(FQCN, marker, Level.ERROR, string, object, object2, null);
    }

    public void error(Marker marker, String string, Object ... objectArray) {
        this.filterAndLog_0_Or3Plus(FQCN, marker, Level.ERROR, string, objectArray, null);
    }

    public void error(Marker marker, String string, Throwable throwable) {
        this.filterAndLog_0_Or3Plus(FQCN, marker, Level.ERROR, string, null, throwable);
    }

    public boolean isInfoEnabled() {
        return this.isInfoEnabled(null);
    }

    public boolean isInfoEnabled(Marker marker) {
        FilterReply filterReply = this.callTurboFilters(marker, Level.INFO);
        if (filterReply == FilterReply.NEUTRAL) {
            return this.effectiveLevelInt <= 20000;
        }
        if (filterReply == FilterReply.DENY) {
            return false;
        }
        if (filterReply == FilterReply.ACCEPT) {
            return true;
        }
        throw new IllegalStateException("Unknown FilterReply value: " + (Object)((Object)filterReply));
    }

    public void info(String string) {
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.INFO, string, null, null);
    }

    public void info(String string, Object object) {
        this.filterAndLog_1(FQCN, null, Level.INFO, string, object, null);
    }

    public void info(String string, Object object, Object object2) {
        this.filterAndLog_2(FQCN, null, Level.INFO, string, object, object2, null);
    }

    public void info(String string, Object ... objectArray) {
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.INFO, string, objectArray, null);
    }

    public void info(String string, Throwable throwable) {
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.INFO, string, null, throwable);
    }

    public void info(Marker marker, String string) {
        this.filterAndLog_0_Or3Plus(FQCN, marker, Level.INFO, string, null, null);
    }

    public void info(Marker marker, String string, Object object) {
        this.filterAndLog_1(FQCN, marker, Level.INFO, string, object, null);
    }

    public void info(Marker marker, String string, Object object, Object object2) {
        this.filterAndLog_2(FQCN, marker, Level.INFO, string, object, object2, null);
    }

    public void info(Marker marker, String string, Object ... objectArray) {
        this.filterAndLog_0_Or3Plus(FQCN, marker, Level.INFO, string, objectArray, null);
    }

    public void info(Marker marker, String string, Throwable throwable) {
        this.filterAndLog_0_Or3Plus(FQCN, marker, Level.INFO, string, null, throwable);
    }

    public boolean isTraceEnabled() {
        return this.isTraceEnabled(null);
    }

    public boolean isTraceEnabled(Marker marker) {
        FilterReply filterReply = this.callTurboFilters(marker, Level.TRACE);
        if (filterReply == FilterReply.NEUTRAL) {
            return this.effectiveLevelInt <= 5000;
        }
        if (filterReply == FilterReply.DENY) {
            return false;
        }
        if (filterReply == FilterReply.ACCEPT) {
            return true;
        }
        throw new IllegalStateException("Unknown FilterReply value: " + (Object)((Object)filterReply));
    }

    public boolean isErrorEnabled() {
        return this.isErrorEnabled(null);
    }

    public boolean isErrorEnabled(Marker marker) {
        FilterReply filterReply = this.callTurboFilters(marker, Level.ERROR);
        if (filterReply == FilterReply.NEUTRAL) {
            return this.effectiveLevelInt <= 40000;
        }
        if (filterReply == FilterReply.DENY) {
            return false;
        }
        if (filterReply == FilterReply.ACCEPT) {
            return true;
        }
        throw new IllegalStateException("Unknown FilterReply value: " + (Object)((Object)filterReply));
    }

    public boolean isWarnEnabled() {
        return this.isWarnEnabled(null);
    }

    public boolean isWarnEnabled(Marker marker) {
        FilterReply filterReply = this.callTurboFilters(marker, Level.WARN);
        if (filterReply == FilterReply.NEUTRAL) {
            return this.effectiveLevelInt <= 30000;
        }
        if (filterReply == FilterReply.DENY) {
            return false;
        }
        if (filterReply == FilterReply.ACCEPT) {
            return true;
        }
        throw new IllegalStateException("Unknown FilterReply value: " + (Object)((Object)filterReply));
    }

    public boolean isEnabledFor(Marker marker, Level level) {
        FilterReply filterReply = this.callTurboFilters(marker, level);
        if (filterReply == FilterReply.NEUTRAL) {
            return this.effectiveLevelInt <= level.levelInt;
        }
        if (filterReply == FilterReply.DENY) {
            return false;
        }
        if (filterReply == FilterReply.ACCEPT) {
            return true;
        }
        throw new IllegalStateException("Unknown FilterReply value: " + (Object)((Object)filterReply));
    }

    public boolean isEnabledFor(Level level) {
        return this.isEnabledFor(null, level);
    }

    public void warn(String string) {
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.WARN, string, null, null);
    }

    public void warn(String string, Throwable throwable) {
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.WARN, string, null, throwable);
    }

    public void warn(String string, Object object) {
        this.filterAndLog_1(FQCN, null, Level.WARN, string, object, null);
    }

    public void warn(String string, Object object, Object object2) {
        this.filterAndLog_2(FQCN, null, Level.WARN, string, object, object2, null);
    }

    public void warn(String string, Object ... objectArray) {
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.WARN, string, objectArray, null);
    }

    public void warn(Marker marker, String string) {
        this.filterAndLog_0_Or3Plus(FQCN, marker, Level.WARN, string, null, null);
    }

    public void warn(Marker marker, String string, Object object) {
        this.filterAndLog_1(FQCN, marker, Level.WARN, string, object, null);
    }

    public void warn(Marker marker, String string, Object ... objectArray) {
        this.filterAndLog_0_Or3Plus(FQCN, marker, Level.WARN, string, objectArray, null);
    }

    public void warn(Marker marker, String string, Object object, Object object2) {
        this.filterAndLog_2(FQCN, marker, Level.WARN, string, object, object2, null);
    }

    public void warn(Marker marker, String string, Throwable throwable) {
        this.filterAndLog_0_Or3Plus(FQCN, marker, Level.WARN, string, null, throwable);
    }

    public boolean isAdditive() {
        return this.additive;
    }

    public void setAdditive(boolean bl) {
        this.additive = bl;
    }

    public String toString() {
        return "Logger[" + this.name + "]";
    }

    private FilterReply callTurboFilters(Marker marker, Level level) {
        return this.loggerContext.getTurboFilterChainDecision_0_3OrMore(marker, this, level, null, null, null);
    }

    public LoggerContext getLoggerContext() {
        return this.loggerContext;
    }

    public void log(Marker marker, String string, int n, String string2, Object[] objectArray, Throwable throwable) {
        Level level = Level.fromLocationAwareLoggerInteger(n);
        this.filterAndLog_0_Or3Plus(string, marker, level, string2, objectArray, throwable);
    }

    public void log(org.slf4j.event.LoggingEvent loggingEvent) {
        Level level = Level.fromLocationAwareLoggerInteger(loggingEvent.getLevel().toInt());
        this.filterAndLog_0_Or3Plus(FQCN, loggingEvent.getMarker(), level, loggingEvent.getMessage(), loggingEvent.getArgumentArray(), loggingEvent.getThrowable());
    }

    protected Object readResolve() throws ObjectStreamException {
        return LoggerFactory.getLogger((String)this.getName());
    }
}

