/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileSize {
    private static final String LENGTH_PART = "([0-9]+)";
    private static final int DOUBLE_GROUP = 1;
    private static final String UNIT_PART = "(|kb|mb|gb)s?";
    private static final int UNIT_GROUP = 2;
    private static final Pattern FILE_SIZE_PATTERN = Pattern.compile("([0-9]+)\\s*(|kb|mb|gb)s?", 2);
    static final long KB_COEFFICIENT = 1024L;
    static final long MB_COEFFICIENT = 0x100000L;
    static final long GB_COEFFICIENT = 0x40000000L;
    final long size;

    FileSize(long l) {
        this.size = l;
    }

    public long getSize() {
        return this.size;
    }

    public static FileSize valueOf(String string) {
        Matcher matcher = FILE_SIZE_PATTERN.matcher(string);
        if (matcher.matches()) {
            long l;
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            long l2 = Long.valueOf(string2);
            if (string3.equalsIgnoreCase("")) {
                l = 1L;
            } else if (string3.equalsIgnoreCase("kb")) {
                l = 1024L;
            } else if (string3.equalsIgnoreCase("mb")) {
                l = 0x100000L;
            } else if (string3.equalsIgnoreCase("gb")) {
                l = 0x40000000L;
            } else {
                throw new IllegalStateException("Unexpected " + string3);
            }
            return new FileSize(l2 * l);
        }
        throw new IllegalArgumentException("String value [" + string + "] is not in the expected format.");
    }
}

