/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.helper.PeriodicityType;
import ch.qos.logback.core.spi.ContextAwareBase;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class RollingCalendar
extends GregorianCalendar {
    private static final long serialVersionUID = -5937537740925066161L;
    static final TimeZone GMT_TIMEZONE = TimeZone.getTimeZone("GMT");
    PeriodicityType periodicityType = PeriodicityType.ERRONEOUS;

    public RollingCalendar() {
    }

    public RollingCalendar(TimeZone timeZone, Locale locale) {
        super(timeZone, locale);
    }

    public void init(String string) {
        this.periodicityType = this.computePeriodicityType(string);
    }

    private void setPeriodicityType(PeriodicityType periodicityType) {
        this.periodicityType = periodicityType;
    }

    public PeriodicityType getPeriodicityType() {
        return this.periodicityType;
    }

    public long getNextTriggeringMillis(Date date) {
        return this.getNextTriggeringDate(date).getTime();
    }

    public PeriodicityType computePeriodicityType(String string) {
        RollingCalendar rollingCalendar = new RollingCalendar(GMT_TIMEZONE, Locale.getDefault());
        Date date = new Date(0L);
        if (string != null) {
            for (PeriodicityType periodicityType : PeriodicityType.VALID_ORDERED_LIST) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, Locale.US);
                simpleDateFormat.setTimeZone(GMT_TIMEZONE);
                String string2 = simpleDateFormat.format(date);
                rollingCalendar.setPeriodicityType(periodicityType);
                Date date2 = new Date(rollingCalendar.getNextTriggeringMillis(date));
                String string3 = simpleDateFormat.format(date2);
                if (string2 == null || string3 == null || string2.equals(string3)) continue;
                return periodicityType;
            }
        }
        return PeriodicityType.ERRONEOUS;
    }

    public void printPeriodicity(ContextAwareBase contextAwareBase) {
        switch (this.periodicityType) {
            case TOP_OF_MILLISECOND: {
                contextAwareBase.addInfo("Roll-over every millisecond.");
                break;
            }
            case TOP_OF_SECOND: {
                contextAwareBase.addInfo("Roll-over every second.");
                break;
            }
            case TOP_OF_MINUTE: {
                contextAwareBase.addInfo("Roll-over every minute.");
                break;
            }
            case TOP_OF_HOUR: {
                contextAwareBase.addInfo("Roll-over at the top of every hour.");
                break;
            }
            case HALF_DAY: {
                contextAwareBase.addInfo("Roll-over at midday and midnight.");
                break;
            }
            case TOP_OF_DAY: {
                contextAwareBase.addInfo("Roll-over at midnight.");
                break;
            }
            case TOP_OF_WEEK: {
                contextAwareBase.addInfo("Rollover at the start of week.");
                break;
            }
            case TOP_OF_MONTH: {
                contextAwareBase.addInfo("Rollover at start of every month.");
                break;
            }
            default: {
                contextAwareBase.addInfo("Unknown periodicity.");
            }
        }
    }

    public long periodsElapsed(long l, long l2) {
        if (l > l2) {
            throw new IllegalArgumentException("Start cannot come before end");
        }
        long l3 = l2 - l;
        switch (this.periodicityType) {
            case TOP_OF_MILLISECOND: {
                return l3;
            }
            case TOP_OF_SECOND: {
                return l3 / 1000L;
            }
            case TOP_OF_MINUTE: {
                return l3 / 60000L;
            }
            case TOP_OF_HOUR: {
                return (int)l3 / 3600000;
            }
            case TOP_OF_DAY: {
                return l3 / 86400000L;
            }
            case TOP_OF_WEEK: {
                return l3 / 604800000L;
            }
            case TOP_OF_MONTH: {
                return RollingCalendar.diffInMonths(l, l2);
            }
        }
        throw new IllegalStateException("Unknown periodicity type.");
    }

    public static int diffInMonths(long l, long l2) {
        if (l > l2) {
            throw new IllegalArgumentException("startTime cannot be larger than endTime");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTimeInMillis(l2);
        int n = calendar2.get(1) - calendar.get(1);
        int n2 = calendar2.get(2) - calendar.get(2);
        return n * 12 + n2;
    }

    public Date getRelativeDate(Date date, int n) {
        this.setTime(date);
        switch (this.periodicityType) {
            case TOP_OF_MILLISECOND: {
                this.add(14, n);
                break;
            }
            case TOP_OF_SECOND: {
                this.set(14, 0);
                this.add(13, n);
                break;
            }
            case TOP_OF_MINUTE: {
                this.set(13, 0);
                this.set(14, 0);
                this.add(12, n);
                break;
            }
            case TOP_OF_HOUR: {
                this.set(12, 0);
                this.set(13, 0);
                this.set(14, 0);
                this.add(11, n);
                break;
            }
            case TOP_OF_DAY: {
                this.set(11, 0);
                this.set(12, 0);
                this.set(13, 0);
                this.set(14, 0);
                this.add(5, n);
                break;
            }
            case TOP_OF_WEEK: {
                this.set(7, this.getFirstDayOfWeek());
                this.set(11, 0);
                this.set(12, 0);
                this.set(13, 0);
                this.set(14, 0);
                this.add(3, n);
                break;
            }
            case TOP_OF_MONTH: {
                this.set(5, 1);
                this.set(11, 0);
                this.set(12, 0);
                this.set(13, 0);
                this.set(14, 0);
                this.add(2, n);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown periodicity type.");
            }
        }
        return this.getTime();
    }

    public Date getNextTriggeringDate(Date date) {
        return this.getRelativeDate(date, 1);
    }
}

