/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.stubbing;

import com.github.tomakehurst.wiremock.admin.NotFoundException;
import com.github.tomakehurst.wiremock.store.ScenariosStore;
import com.github.tomakehurst.wiremock.stubbing.Scenario;
import com.github.tomakehurst.wiremock.stubbing.Scenarios;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class AbstractScenarios
implements Scenarios {
    private final ScenariosStore store;

    public AbstractScenarios(ScenariosStore store) {
        this.store = store;
    }

    @Override
    public Scenario getByName(String name) {
        return this.store.get(name).orElse(null);
    }

    @Override
    public List<Scenario> getAll() {
        return ImmutableList.copyOf((Collection)this.store.getAll().collect(Collectors.toList()));
    }

    @Override
    public void onStubMappingAdded(StubMapping mapping) {
        if (mapping.isInScenario()) {
            String scenarioName = mapping.getScenarioName();
            Scenario scenario = ((Scenario)MoreObjects.firstNonNull((Object)this.store.get(scenarioName).orElse(null), (Object)Scenario.inStartedState(scenarioName))).withStubMapping(mapping);
            this.store.put(scenarioName, scenario);
        }
    }

    @Override
    public void onStubMappingUpdated(StubMapping oldMapping, StubMapping newMapping) {
        if (oldMapping.isInScenario() && !oldMapping.getScenarioName().equals(newMapping.getScenarioName())) {
            Scenario scenarioForOldMapping = this.store.get(oldMapping.getScenarioName()).map(scenario -> scenario.withoutStubMapping(oldMapping)).orElseThrow(IllegalStateException::new);
            if (scenarioForOldMapping.getMappings().isEmpty()) {
                this.store.remove(scenarioForOldMapping.getId());
            } else {
                this.store.put(oldMapping.getScenarioName(), scenarioForOldMapping);
            }
        }
        if (newMapping.isInScenario()) {
            String scenarioName = newMapping.getScenarioName();
            Scenario scenario2 = ((Scenario)MoreObjects.firstNonNull((Object)this.store.get(scenarioName).orElse(null), (Object)Scenario.inStartedState(scenarioName))).withStubMapping(newMapping);
            this.store.put(scenarioName, scenario2);
        }
    }

    @Override
    public void onStubMappingRemoved(StubMapping mapping) {
        if (mapping.isInScenario()) {
            String scenarioName = mapping.getScenarioName();
            Scenario scenario = ((Scenario)this.store.get(scenarioName).orElseThrow(IllegalStateException::new)).withoutStubMapping(mapping);
            if (scenario.getMappings().isEmpty()) {
                this.store.remove(scenarioName);
            } else {
                this.store.put(scenarioName, scenario);
            }
        }
    }

    @Override
    public void onStubServed(StubMapping mapping) {
        if (mapping.isInScenario()) {
            String scenarioName = mapping.getScenarioName();
            Scenario scenario = (Scenario)this.store.get(scenarioName).orElseThrow(IllegalStateException::new);
            if (mapping.modifiesScenarioState() && (mapping.getRequiredScenarioState() == null || scenario.getState().equals(mapping.getRequiredScenarioState()))) {
                Scenario newScenario = scenario.setState(mapping.getNewScenarioState());
                this.store.put(scenarioName, newScenario);
            }
        }
    }

    @Override
    public void reset() {
        this.store.getAll().map(Scenario::reset).forEach(scenario -> this.store.put(scenario.getId(), scenario));
    }

    @Override
    public void resetSingle(String name) {
        this.setSingleScenarioState(name, Scenario::reset);
    }

    @Override
    public void setSingle(String name, String state) {
        this.setSingleScenarioState(name, scenario -> scenario.setState(state));
    }

    private void setSingleScenarioState(String name, Function<Scenario, Scenario> fn) {
        Scenario scenario = (Scenario)this.store.get(name).orElseThrow(() -> new NotFoundException("Scenario " + name + " does not exist"));
        this.store.put(name, fn.apply(scenario));
    }

    @Override
    public void clear() {
        this.store.clear();
    }

    @Override
    public boolean mappingMatchesScenarioState(StubMapping mapping) {
        String currentScenarioState = this.getByName(mapping.getScenarioName()).getState();
        return mapping.getRequiredScenarioState().equals(currentScenarioState);
    }
}

