/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.Collection;
import java.util.Map;

public class MatchesJsonPathPattern
extends StringValuePattern {
    public MatchesJsonPathPattern(@JsonProperty(value="matchesJsonPath") String value) {
        super(value);
    }

    public String getMatchesJsonPath() {
        return (String)this.expectedValue;
    }

    @Override
    public MatchResult match(String value) {
        return MatchResult.of(this.isJsonPathMatch(value));
    }

    private boolean isJsonPathMatch(String value) {
        try {
            Object obj = JsonPath.read((String)value, (String)((String)this.expectedValue), (Predicate[])new Predicate[0]);
            if (obj instanceof Collection) {
                return !((Collection)obj).isEmpty();
            }
            if (obj instanceof Map) {
                return !((Map)obj).isEmpty();
            }
            return obj != null;
        }
        catch (Exception e) {
            String error = e.getMessage().equalsIgnoreCase("invalid path") ? "the JSON path didn't match the document structure" : (e.getMessage().equalsIgnoreCase("invalid container object") ? "the JSON document couldn't be parsed" : "of error '" + e.getMessage() + "'");
            String message = String.format("Warning: JSON path expression '%s' failed to match document '%s' because %s", this.expectedValue, value, error);
            LocalNotifier.notifier().info(message);
            return false;
        }
    }
}

