/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.core;

import com.github.tomakehurst.wiremock.common.ClasspathFileSource;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.HttpsSettings;
import com.github.tomakehurst.wiremock.common.JettySettings;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.common.ProxySettings;
import com.github.tomakehurst.wiremock.common.SingleRootFileSource;
import com.github.tomakehurst.wiremock.common.Slf4jNotifier;
import com.github.tomakehurst.wiremock.core.MappingsSaver;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.ExtensionLoader;
import com.github.tomakehurst.wiremock.http.CaseInsensitiveKey;
import com.github.tomakehurst.wiremock.http.HttpServerFactory;
import com.github.tomakehurst.wiremock.jetty9.JettyHttpServerFactory;
import com.github.tomakehurst.wiremock.standalone.JsonFileMappingsSource;
import com.github.tomakehurst.wiremock.standalone.MappingsLoader;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Resources;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class WireMockConfiguration
implements Options {
    private int portNumber = 8080;
    private String bindAddress = "0.0.0.0";
    private int containerThreads = 10;
    private int httpsPort = -1;
    private String keyStorePath = Resources.getResource((String)"keystore").toString();
    private String keyStorePassword = "password";
    private String keyStoreType = "JKS";
    private String trustStorePath;
    private String trustStorePassword = "password";
    private String trustStoreType = "JKS";
    private boolean needClientAuth;
    private boolean browserProxyingEnabled = false;
    private ProxySettings proxySettings = ProxySettings.NO_PROXY;
    private FileSource filesRoot = new SingleRootFileSource("src/test/resources");
    private Notifier notifier = new Slf4jNotifier(false);
    private boolean requestJournalDisabled = false;
    private Optional<Integer> maxRequestJournalEntries = Optional.absent();
    private List<CaseInsensitiveKey> matchingHeaders = Collections.emptyList();
    private boolean preserveHostHeader;
    private String proxyHostHeader;
    private HttpServerFactory httpServerFactory = new JettyHttpServerFactory();
    private Integer jettyAcceptors;
    private Integer jettyAcceptQueueSize;
    private Integer jettyHeaderBufferSize;
    private Map<String, Extension> extensions = Maps.newLinkedHashMap();

    public static WireMockConfiguration wireMockConfig() {
        return new WireMockConfiguration();
    }

    public static WireMockConfiguration options() {
        return WireMockConfiguration.wireMockConfig();
    }

    public WireMockConfiguration port(int portNumber) {
        this.portNumber = portNumber;
        return this;
    }

    public WireMockConfiguration dynamicPort() {
        this.portNumber = 0;
        return this;
    }

    public WireMockConfiguration httpsPort(Integer httpsPort) {
        this.httpsPort = httpsPort;
        return this;
    }

    public WireMockConfiguration dynamicHttpsPort() {
        this.httpsPort = 0;
        return this;
    }

    public WireMockConfiguration containerThreads(Integer containerThreads) {
        this.containerThreads = containerThreads;
        return this;
    }

    public WireMockConfiguration jettyAcceptors(Integer jettyAcceptors) {
        this.jettyAcceptors = jettyAcceptors;
        return this;
    }

    public WireMockConfiguration jettyAcceptQueueSize(Integer jettyAcceptQueueSize) {
        this.jettyAcceptQueueSize = jettyAcceptQueueSize;
        return this;
    }

    public WireMockConfiguration jettyHeaderBufferSize(Integer jettyHeaderBufferSize) {
        this.jettyHeaderBufferSize = jettyHeaderBufferSize;
        return this;
    }

    public WireMockConfiguration keystorePath(String path) {
        this.keyStorePath = path;
        return this;
    }

    public WireMockConfiguration keystorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
        return this;
    }

    public WireMockConfiguration keystoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
        return this;
    }

    public WireMockConfiguration trustStorePath(String truststorePath) {
        this.trustStorePath = truststorePath;
        return this;
    }

    public WireMockConfiguration trustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
        return this;
    }

    public WireMockConfiguration trustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
        return this;
    }

    public WireMockConfiguration needClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
        return this;
    }

    public WireMockConfiguration enableBrowserProxying(boolean enabled) {
        this.browserProxyingEnabled = enabled;
        return this;
    }

    public WireMockConfiguration proxyVia(String host, int port) {
        this.proxySettings = new ProxySettings(host, port);
        return this;
    }

    public WireMockConfiguration proxyVia(ProxySettings proxySettings) {
        this.proxySettings = proxySettings;
        return this;
    }

    public WireMockConfiguration withRootDirectory(String path) {
        this.filesRoot = new SingleRootFileSource(path);
        return this;
    }

    public WireMockConfiguration usingFilesUnderDirectory(String path) {
        return this.withRootDirectory(path);
    }

    public WireMockConfiguration usingFilesUnderClasspath(String path) {
        this.filesRoot = new ClasspathFileSource(path);
        return this;
    }

    public WireMockConfiguration fileSource(FileSource fileSource) {
        this.filesRoot = fileSource;
        return this;
    }

    public WireMockConfiguration notifier(Notifier notifier) {
        this.notifier = notifier;
        return this;
    }

    public WireMockConfiguration bindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
        return this;
    }

    public WireMockConfiguration disableRequestJournal() {
        this.requestJournalDisabled = true;
        return this;
    }

    public WireMockConfiguration maxRequestJournalEntries(Optional<Integer> maxRequestJournalEntries) {
        this.maxRequestJournalEntries = maxRequestJournalEntries;
        return this;
    }

    public WireMockConfiguration recordRequestHeadersForMatching(List<String> headers) {
        this.matchingHeaders = Lists.transform(headers, CaseInsensitiveKey.TO_CASE_INSENSITIVE_KEYS);
        return this;
    }

    public WireMockConfiguration preserveHostHeader(boolean preserveHostHeader) {
        this.preserveHostHeader = preserveHostHeader;
        return this;
    }

    public WireMockConfiguration proxyHostHeader(String hostHeaderValue) {
        this.proxyHostHeader = hostHeaderValue;
        return this;
    }

    public WireMockConfiguration extensions(String ... classNames) {
        this.extensions.putAll(ExtensionLoader.load(classNames));
        return this;
    }

    public WireMockConfiguration extensions(Extension ... extensionInstances) {
        this.extensions.putAll(ExtensionLoader.asMap(Arrays.asList(extensionInstances)));
        return this;
    }

    public WireMockConfiguration extensions(Class<? extends Extension> ... classes) {
        this.extensions.putAll(ExtensionLoader.load(classes));
        return this;
    }

    public WireMockConfiguration httpServerFactory(HttpServerFactory serverFactory) {
        this.httpServerFactory = serverFactory;
        return this;
    }

    @Override
    public int portNumber() {
        return this.portNumber;
    }

    @Override
    public int containerThreads() {
        return this.containerThreads;
    }

    @Override
    public HttpsSettings httpsSettings() {
        return new HttpsSettings.Builder().port(this.httpsPort).keyStorePath(this.keyStorePath).keyStorePassword(this.keyStorePassword).keyStoreType(this.keyStoreType).trustStorePath(this.trustStorePath).trustStorePassword(this.trustStorePassword).trustStoreType(this.trustStoreType).needClientAuth(this.needClientAuth).build();
    }

    @Override
    public JettySettings jettySettings() {
        return JettySettings.Builder.aJettySettings().withAcceptors(this.jettyAcceptors).withAcceptQueueSize(this.jettyAcceptQueueSize).withRequestHeaderSize(this.jettyHeaderBufferSize).build();
    }

    @Override
    public boolean browserProxyingEnabled() {
        return this.browserProxyingEnabled;
    }

    @Override
    public ProxySettings proxyVia() {
        return this.proxySettings;
    }

    @Override
    public FileSource filesRoot() {
        return this.filesRoot;
    }

    @Override
    public MappingsLoader mappingsLoader() {
        return new JsonFileMappingsSource(this.filesRoot.child("mappings"));
    }

    @Override
    public MappingsSaver mappingsSaver() {
        return new JsonFileMappingsSource(this.filesRoot.child("mappings"));
    }

    @Override
    public Notifier notifier() {
        return this.notifier;
    }

    @Override
    public boolean requestJournalDisabled() {
        return this.requestJournalDisabled;
    }

    @Override
    public Optional<Integer> maxRequestJournalEntries() {
        return this.maxRequestJournalEntries;
    }

    @Override
    public String bindAddress() {
        return this.bindAddress;
    }

    @Override
    public List<CaseInsensitiveKey> matchingHeaders() {
        return this.matchingHeaders;
    }

    @Override
    public HttpServerFactory httpServerFactory() {
        return this.httpServerFactory;
    }

    @Override
    public boolean shouldPreserveHostHeader() {
        return this.preserveHostHeader;
    }

    @Override
    public String proxyHostHeader() {
        return this.proxyHostHeader;
    }

    @Override
    public <T extends Extension> Map<String, T> extensionsOfType(Class<T> extensionType) {
        return Maps.filterEntries(this.extensions, ExtensionLoader.valueAssignableFrom(extensionType));
    }
}

