/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.common.Xml;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;

public class ContentTypes {
    private static final Map<String, String> COMMON_MIME_TYPES = ImmutableMap.builder().put((Object)"image/jpeg", (Object)"jpeg").put((Object)"image/gif", (Object)"gif").put((Object)"image/tiff", (Object)"tiff").put((Object)"image/png", (Object)"png").put((Object)"image/x-icon", (Object)"ico").put((Object)"image/svg+xml", (Object)"svg").put((Object)"audio/x-aiff", (Object)"aiff").put((Object)"video/x-ms-asf", (Object)"asf").put((Object)"video/mpeg", (Object)"mp2").put((Object)"audio/mpeg", (Object)"mp3").put((Object)"video/quicktime", (Object)"mov").put((Object)"application/pdf", (Object)"pdf").build();

    public static String determineFileExtension(String url, ContentTypeHeader contentTypeHeader, byte[] responseBody) {
        String path;
        if (contentTypeHeader.isPresent()) {
            if (contentTypeHeader.mimeTypePart().contains("json")) {
                return "json";
            }
            if (contentTypeHeader.mimeTypePart().contains("xml")) {
                return "xml";
            }
            if (contentTypeHeader.mimeTypePart().contains("text")) {
                return "txt";
            }
            String extension = COMMON_MIME_TYPES.get(contentTypeHeader.mimeTypePart());
            if (extension != null) {
                return extension;
            }
        }
        if ((path = URI.create(url).getPath()).indexOf(46) != -1) {
            return path.substring(path.lastIndexOf(46) + 1, path.length());
        }
        return ContentTypes.determineTextFileExtension(Strings.stringFromBytes(responseBody));
    }

    public static String determineTextFileExtension(String content) {
        try {
            Json.read(content, JsonNode.class);
            return "json";
        }
        catch (Exception e) {
            try {
                Xml.read(content);
                return "xml";
            }
            catch (Exception e1) {
                return "txt";
            }
        }
    }
}

