/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.stubbing;

import com.github.tomakehurst.wiremock.stubbing.Scenario;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class Scenarios {
    private final ConcurrentHashMap<String, Scenario> scenarioMap = new ConcurrentHashMap();

    public Scenario getByName(String name) {
        return this.scenarioMap.get(name);
    }

    public List<Scenario> getAll() {
        return ImmutableList.copyOf(this.scenarioMap.values());
    }

    public void onStubMappingAddedOrUpdated(StubMapping mapping, Iterable<StubMapping> allStubMappings) {
        if (mapping.isInScenario()) {
            String scenarioName = mapping.getScenarioName();
            Scenario scenario = (Scenario)MoreObjects.firstNonNull((Object)this.scenarioMap.get(scenarioName), (Object)Scenario.inStartedState(scenarioName));
            scenario = scenario.withPossibleState(mapping.getNewScenarioState());
            this.scenarioMap.put(scenarioName, scenario);
            this.cleanUnusedScenarios(allStubMappings);
        }
    }

    private void cleanUnusedScenarios(Iterable<StubMapping> remainingStubMappings) {
        for (String scenarioName : this.scenarioMap.keySet()) {
            if (Scenarios.countOtherStubsInScenario(remainingStubMappings, scenarioName) != 0) continue;
            this.scenarioMap.remove(scenarioName);
        }
    }

    public void onStubMappingRemoved(StubMapping mapping, Iterable<StubMapping> remainingStubMappings) {
        if (mapping.isInScenario()) {
            String scenarioName = mapping.getScenarioName();
            if (Scenarios.countOtherStubsInScenario(remainingStubMappings, scenarioName) == 0) {
                this.scenarioMap.remove(scenarioName);
            } else {
                Scenario scenario = this.scenarioMap.get(scenarioName);
                scenario = scenario.withoutPossibleState(mapping.getNewScenarioState());
                this.scenarioMap.put(scenarioName, scenario);
            }
        }
    }

    public void onStubServed(StubMapping mapping) {
        if (mapping.isInScenario()) {
            String scenarioName = mapping.getScenarioName();
            Scenario scenario = this.scenarioMap.get(scenarioName);
            if (mapping.modifiesScenarioState() && (mapping.getRequiredScenarioState() == null || scenario.getState().equals(mapping.getRequiredScenarioState()))) {
                Scenario newScenario = scenario.setState(mapping.getNewScenarioState());
                this.scenarioMap.put(scenarioName, newScenario);
            }
        }
    }

    public void reset() {
        this.scenarioMap.putAll(Maps.transformValues(this.scenarioMap, (Function)new Function<Scenario, Scenario>(){

            public Scenario apply(Scenario input) {
                return input.reset();
            }
        }));
    }

    public void clear() {
        this.scenarioMap.clear();
    }

    public boolean mappingMatchesScenarioState(StubMapping mapping) {
        String currentScenarioState = this.getByName(mapping.getScenarioName()).getState();
        return mapping.getRequiredScenarioState().equals(currentScenarioState);
    }

    private static int countOtherStubsInScenario(Iterable<StubMapping> remainingStubMappings, final String scenarioName) {
        return FluentIterable.from(remainingStubMappings).filter((Predicate)new Predicate<StubMapping>(){

            public boolean apply(StubMapping input) {
                return scenarioName.equals(input.getScenarioName());
            }
        }).size();
    }
}

