/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.flipkart.zjsonpatch.JsonDiff;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.math.NumberUtils;

public class EqualToJsonPattern
extends StringValuePattern {
    private final JsonNode expected;
    private final Boolean ignoreArrayOrder;
    private final Boolean ignoreExtraElements;
    private final Boolean serializeAsString;

    public EqualToJsonPattern(@JsonProperty(value="equalToJson") String json, @JsonProperty(value="ignoreArrayOrder") Boolean ignoreArrayOrder, @JsonProperty(value="ignoreExtraElements") Boolean ignoreExtraElements) {
        super(json);
        this.expected = Json.read(json, JsonNode.class);
        this.ignoreArrayOrder = ignoreArrayOrder;
        this.ignoreExtraElements = ignoreExtraElements;
        this.serializeAsString = true;
    }

    public EqualToJsonPattern(JsonNode jsonNode, Boolean ignoreArrayOrder, Boolean ignoreExtraElements) {
        super(Json.write(jsonNode));
        this.expected = jsonNode;
        this.ignoreArrayOrder = ignoreArrayOrder;
        this.ignoreExtraElements = ignoreExtraElements;
        this.serializeAsString = false;
    }

    @JsonProperty(value="equalToJson")
    public Object getSerializedEqualToJson() {
        return this.serializeAsString != false ? this.getValue() : this.expected;
    }

    public String getEqualToJson() {
        return (String)this.expectedValue;
    }

    private boolean shouldIgnoreArrayOrder() {
        return this.ignoreArrayOrder != null && this.ignoreArrayOrder != false;
    }

    public Boolean isIgnoreArrayOrder() {
        return this.ignoreArrayOrder;
    }

    private boolean shouldIgnoreExtraElements() {
        return this.ignoreArrayOrder != null && this.ignoreExtraElements != false;
    }

    public Boolean isIgnoreExtraElements() {
        return this.ignoreExtraElements;
    }

    @Override
    public String getExpected() {
        return Json.prettyPrint((String)this.getValue());
    }

    @Override
    public MatchResult match(String value) {
        try {
            final JsonNode actual = Json.read(value, JsonNode.class);
            return new MatchResult(){

                @Override
                public boolean isExactMatch() {
                    return !EqualToJsonPattern.this.shouldIgnoreArrayOrder() && !EqualToJsonPattern.this.shouldIgnoreExtraElements() && Objects.equals(actual, EqualToJsonPattern.this.expected) || this.getDistance() == 0.0;
                }

                @Override
                public double getDistance() {
                    ArrayNode diff = (ArrayNode)JsonDiff.asJson((JsonNode)EqualToJsonPattern.this.expected, (JsonNode)actual);
                    double maxNodes = Json.maxDeepSize(EqualToJsonPattern.this.expected, actual);
                    return (double)EqualToJsonPattern.this.diffSize(diff) / maxNodes;
                }
            };
        }
        catch (Exception e) {
            return MatchResult.noMatch();
        }
    }

    private int diffSize(ArrayNode diff) {
        int acc = 0;
        for (JsonNode child : diff) {
            JsonNode pathString;
            List<String> path;
            String operation = child.findValue("op").textValue();
            if (this.arrayOrderIgnoredAndIsArrayMove(operation, path = EqualToJsonPattern.getPath((pathString = EqualToJsonPattern.getFromPathString(operation, child)).textValue())) || this.extraElementsIgnoredAndIsAddition(operation)) continue;
            JsonNode valueNode = child.findValue("value");
            JsonNode referencedExpectedNode = EqualToJsonPattern.getNodeAtPath(this.expected, pathString);
            if (valueNode == null) {
                acc += Json.deepSize(referencedExpectedNode);
                continue;
            }
            acc += Json.maxDeepSize(referencedExpectedNode, valueNode);
        }
        return acc;
    }

    private static JsonNode getFromPathString(String operation, JsonNode node) {
        if (operation.equals("move")) {
            return node.findValue("from");
        }
        return node.findValue("path");
    }

    private boolean extraElementsIgnoredAndIsAddition(String operation) {
        return operation.equals("add") && this.shouldIgnoreExtraElements();
    }

    private boolean arrayOrderIgnoredAndIsArrayMove(String operation, List<String> path) {
        return operation.equals("move") && NumberUtils.isNumber((String)((String)Iterables.getLast(path))) && this.shouldIgnoreArrayOrder();
    }

    public static JsonNode getNodeAtPath(JsonNode rootNode, JsonNode path) {
        String pathString = path.toString().equals("\"/\"") ? "\"\"" : path.toString();
        return EqualToJsonPattern.getNode(rootNode, EqualToJsonPattern.getPath(pathString), 1);
    }

    private static JsonNode getNode(JsonNode ret, List<String> path, int pos) {
        if (pos >= path.size()) {
            return ret;
        }
        if (ret == null) {
            return null;
        }
        String key = path.get(pos);
        if (ret.isArray()) {
            int keyInt = Integer.parseInt(key.replaceAll("\"", ""));
            return EqualToJsonPattern.getNode(ret.get(keyInt), path, ++pos);
        }
        if (ret.isObject()) {
            if (ret.has(key)) {
                return EqualToJsonPattern.getNode(ret.get(key), path, ++pos);
            }
            return null;
        }
        return ret;
    }

    private static List<String> getPath(String path) {
        List paths = Splitter.on((char)'/').splitToList((CharSequence)path.replaceAll("\"", ""));
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)paths, (Function)new DecodePathFunction()));
    }

    private static final class DecodePathFunction
    implements Function<String, String> {
        private DecodePathFunction() {
        }

        public String apply(String path) {
            return path.replaceAll("~1", "/").replaceAll("~0", "~");
        }
    }
}

