/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.matching.EagerMatchResult;
import java.util.Arrays;
import java.util.List;

public abstract class MatchResult
implements Comparable<MatchResult> {
    @JsonCreator
    public static EagerMatchResult partialMatch(@JsonProperty(value="distance") double distance) {
        return new EagerMatchResult(distance);
    }

    public static EagerMatchResult exactMatch() {
        return new EagerMatchResult(0.0);
    }

    public static EagerMatchResult noMatch() {
        return new EagerMatchResult(1.0);
    }

    public static EagerMatchResult of(boolean isMatch) {
        return isMatch ? MatchResult.exactMatch() : MatchResult.noMatch();
    }

    public static EagerMatchResult aggregate(List<MatchResult> matches) {
        double totalDistance = 0.0;
        for (MatchResult matchResult : matches) {
            totalDistance += matchResult.getDistance();
        }
        return MatchResult.partialMatch(totalDistance / (double)matches.size());
    }

    public static EagerMatchResult aggregate(MatchResult ... matches) {
        return MatchResult.aggregate(Arrays.asList(matches));
    }

    @JsonIgnore
    public abstract boolean isExactMatch();

    public abstract double getDistance();

    @Override
    public int compareTo(MatchResult other) {
        return Double.compare(other.getDistance(), this.getDistance());
    }
}

