/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.client;

import com.github.tomakehurst.wiremock.client.CountMatchingStrategy;
import com.github.tomakehurst.wiremock.client.HttpAdminClient;
import com.github.tomakehurst.wiremock.client.LocalMappingBuilder;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.RemoteMappingBuilder;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.VerificationException;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.global.GlobalSettings;
import com.github.tomakehurst.wiremock.global.GlobalSettingsHolder;
import com.github.tomakehurst.wiremock.http.DelayDistribution;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.matching.AnythingPattern;
import com.github.tomakehurst.wiremock.matching.ContainsPattern;
import com.github.tomakehurst.wiremock.matching.EqualToJsonPattern;
import com.github.tomakehurst.wiremock.matching.EqualToPattern;
import com.github.tomakehurst.wiremock.matching.EqualToXmlPattern;
import com.github.tomakehurst.wiremock.matching.LocalRequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.MatchesJsonPathPattern;
import com.github.tomakehurst.wiremock.matching.MatchesXPathPattern;
import com.github.tomakehurst.wiremock.matching.NegativeRegexPattern;
import com.github.tomakehurst.wiremock.matching.RegexPattern;
import com.github.tomakehurst.wiremock.matching.RequestMatcher;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.UrlPathPattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.stubbing.ListStubMappingsResult;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.verification.Diff;
import com.github.tomakehurst.wiremock.verification.FindNearMissesResult;
import com.github.tomakehurst.wiremock.verification.FindRequestsResult;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.github.tomakehurst.wiremock.verification.NearMiss;
import com.github.tomakehurst.wiremock.verification.VerificationResult;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class WireMock {
    private static final int DEFAULT_PORT = 8080;
    private static final String DEFAULT_HOST = "localhost";
    private final Admin admin;
    private final GlobalSettingsHolder globalSettingsHolder = new GlobalSettingsHolder();
    private static ThreadLocal<WireMock> defaultInstance = new ThreadLocal<WireMock>(){

        @Override
        protected WireMock initialValue() {
            return new WireMock();
        }
    };

    public WireMock(Admin admin) {
        this.admin = admin;
    }

    public WireMock(int port) {
        this(DEFAULT_HOST, port);
    }

    public WireMock(String host, int port) {
        this.admin = new HttpAdminClient(host, port);
    }

    public WireMock(String host, int port, String urlPathPrefix) {
        this.admin = new HttpAdminClient(host, port, urlPathPrefix);
    }

    public WireMock(String scheme, String host, int port) {
        this.admin = new HttpAdminClient(scheme, host, port);
    }

    public WireMock(String scheme, String host, int port, String urlPathPrefix) {
        this.admin = new HttpAdminClient(scheme, host, port, urlPathPrefix);
    }

    public WireMock() {
        this.admin = new HttpAdminClient(DEFAULT_HOST, 8080);
    }

    public static void givenThat(RemoteMappingBuilder mappingBuilder) {
        defaultInstance.get().register(mappingBuilder);
    }

    public static void stubFor(RemoteMappingBuilder mappingBuilder) {
        WireMock.givenThat(mappingBuilder);
    }

    public static void editStub(MappingBuilder mappingBuilder) {
        defaultInstance.get().editStubMapping(mappingBuilder);
    }

    public static ListStubMappingsResult listAllStubMappings() {
        return defaultInstance.get().allStubMappings();
    }

    public static void configureFor(int port) {
        defaultInstance.set(new WireMock(port));
    }

    public static void configureFor(String host, int port) {
        defaultInstance.set(new WireMock(host, port));
    }

    public static void configureFor(String host, int port, String urlPathPrefix) {
        defaultInstance.set(new WireMock(host, port, urlPathPrefix));
    }

    public static void configureFor(String scheme, String host, int port, String urlPathPrefix) {
        defaultInstance.set(new WireMock(scheme, host, port, urlPathPrefix));
    }

    public static void configureFor(String scheme, String host, int port) {
        defaultInstance.set(new WireMock(scheme, host, port));
    }

    public static void configure() {
        defaultInstance.set(new WireMock());
    }

    public static StringValuePattern equalTo(String value) {
        return new EqualToPattern(value);
    }

    public static StringValuePattern equalToJson(String value) {
        return new EqualToJsonPattern(value, null, null);
    }

    public static StringValuePattern equalToJson(String value, boolean ignoreArrayOrder, boolean ignoreExtraElements) {
        return new EqualToJsonPattern(value, ignoreArrayOrder, ignoreExtraElements);
    }

    public static StringValuePattern matchingJsonPath(String value) {
        return new MatchesJsonPathPattern(value);
    }

    public static StringValuePattern equalToXml(String value) {
        return new EqualToXmlPattern(value);
    }

    public static MatchesXPathPattern matchingXPath(String value) {
        return new MatchesXPathPattern(value, Collections.emptyMap());
    }

    public static StringValuePattern matchingXPath(String value, Map<String, String> namespaces) {
        return new MatchesXPathPattern(value, namespaces);
    }

    public static StringValuePattern containing(String value) {
        return new ContainsPattern(value);
    }

    public static StringValuePattern matching(String regex) {
        return new RegexPattern(regex);
    }

    public static StringValuePattern notMatching(String regex) {
        return new NegativeRegexPattern(regex);
    }

    public static StringValuePattern absent() {
        return StringValuePattern.ABSENT;
    }

    public void saveMappings() {
        this.admin.saveMappings();
    }

    public static void saveAllMappings() {
        defaultInstance.get().saveMappings();
    }

    public void resetMappings() {
        this.admin.resetMappings();
    }

    public static void reset() {
        defaultInstance.get().resetMappings();
    }

    public static void resetAllRequests() {
        defaultInstance.get().resetRequests();
    }

    public void resetRequests() {
        this.admin.resetRequests();
    }

    public void resetScenarios() {
        this.admin.resetScenarios();
    }

    public static void resetAllScenarios() {
        defaultInstance.get().resetScenarios();
    }

    public void resetToDefaultMappings() {
        this.admin.resetToDefaultMappings();
    }

    public static void resetToDefault() {
        defaultInstance.get().resetToDefaultMappings();
    }

    public void register(RemoteMappingBuilder mappingBuilder) {
        StubMapping mapping = mappingBuilder.build();
        this.register(mapping);
    }

    public void register(StubMapping mapping) {
        this.admin.addStubMapping(mapping);
    }

    public void editStubMapping(RemoteMappingBuilder mappingBuilder) {
        this.admin.editStubMapping(mappingBuilder.build());
    }

    public ListStubMappingsResult allStubMappings() {
        return this.admin.listAllStubMappings();
    }

    public static UrlPattern urlEqualTo(String testUrl) {
        return new UrlPattern(WireMock.equalTo(testUrl), false);
    }

    public static UrlPattern urlMatching(String urlRegex) {
        return new UrlPattern(WireMock.matching(urlRegex), true);
    }

    public static UrlPathPattern urlPathEqualTo(String testUrl) {
        return new UrlPathPattern(WireMock.equalTo(testUrl), false);
    }

    public static UrlPathPattern urlPathMatching(String urlRegex) {
        return new UrlPathPattern(WireMock.matching(urlRegex), true);
    }

    public static UrlPattern anyUrl() {
        return new UrlPattern(new AnythingPattern(), false);
    }

    public static CountMatchingStrategy lessThan(int expected) {
        return new CountMatchingStrategy(CountMatchingStrategy.LESS_THAN, expected);
    }

    public static CountMatchingStrategy lessThanOrExactly(int expected) {
        return new CountMatchingStrategy(CountMatchingStrategy.LESS_THAN_OR_EQUAL, expected);
    }

    public static CountMatchingStrategy exactly(int expected) {
        return new CountMatchingStrategy(CountMatchingStrategy.EQUAL_TO, expected);
    }

    public static CountMatchingStrategy moreThanOrExactly(int expected) {
        return new CountMatchingStrategy(CountMatchingStrategy.GREATER_THAN_OR_EQUAL, expected);
    }

    public static CountMatchingStrategy moreThan(int expected) {
        return new CountMatchingStrategy(CountMatchingStrategy.GREATER_THAN, expected);
    }

    public static RemoteMappingBuilder get(UrlPattern urlPattern) {
        return new MappingBuilder(RequestMethod.GET, urlPattern);
    }

    public static RemoteMappingBuilder post(UrlPattern urlPattern) {
        return new MappingBuilder(RequestMethod.POST, urlPattern);
    }

    public static RemoteMappingBuilder put(UrlPattern urlPattern) {
        return new MappingBuilder(RequestMethod.PUT, urlPattern);
    }

    public static RemoteMappingBuilder delete(UrlPattern urlPattern) {
        return new MappingBuilder(RequestMethod.DELETE, urlPattern);
    }

    public static RemoteMappingBuilder patch(UrlPattern urlPattern) {
        return new MappingBuilder(RequestMethod.PATCH, urlPattern);
    }

    public static RemoteMappingBuilder head(UrlPattern urlPattern) {
        return new MappingBuilder(RequestMethod.HEAD, urlPattern);
    }

    public static RemoteMappingBuilder options(UrlPattern urlPattern) {
        return new MappingBuilder(RequestMethod.OPTIONS, urlPattern);
    }

    public static RemoteMappingBuilder trace(UrlPattern urlPattern) {
        return new MappingBuilder(RequestMethod.TRACE, urlPattern);
    }

    public static RemoteMappingBuilder any(UrlPattern urlPattern) {
        return new MappingBuilder(RequestMethod.ANY, urlPattern);
    }

    public static RemoteMappingBuilder request(String method, UrlPattern urlPattern) {
        return new MappingBuilder(RequestMethod.fromString(method), urlPattern);
    }

    public static MappingBuilder requestMatching(String customRequestMatcherName) {
        return new MappingBuilder(customRequestMatcherName, Parameters.empty());
    }

    public static RemoteMappingBuilder requestMatching(String customRequestMatcherName, Parameters parameters) {
        return new MappingBuilder(customRequestMatcherName, parameters);
    }

    public static LocalMappingBuilder requestMatching(RequestMatcher requestMatcher) {
        return new MappingBuilder(requestMatcher);
    }

    public static ResponseDefinitionBuilder aResponse() {
        return new ResponseDefinitionBuilder();
    }

    public void verifyThat(RequestPatternBuilder requestPatternBuilder) {
        RequestPattern requestPattern = requestPatternBuilder.build();
        VerificationResult result = this.admin.countRequestsMatching(requestPattern);
        result.assertRequestJournalEnabled();
        if (result.getCount() < 1) {
            List<NearMiss> nearMisses = this.findAllNearMissesFor(requestPatternBuilder);
            if (nearMisses.size() > 0) {
                Diff diff = new Diff(requestPattern, nearMisses.get(0).getRequest());
                throw VerificationException.forUnmatchedRequestPattern(diff);
            }
            throw new VerificationException(requestPattern, this.find(RequestPatternBuilder.allRequests()));
        }
    }

    public void verifyThat(int expectedCount, RequestPatternBuilder requestPatternBuilder) {
        RequestPattern requestPattern = requestPatternBuilder.build();
        VerificationResult result = this.admin.countRequestsMatching(requestPattern);
        result.assertRequestJournalEnabled();
        int actualCount = result.getCount();
        if (actualCount != expectedCount) {
            throw actualCount == 0 ? this.verificationExceptionForNearMisses(requestPatternBuilder, requestPattern) : new VerificationException(requestPattern, expectedCount, actualCount);
        }
    }

    public void verifyThat(CountMatchingStrategy expectedCount, RequestPatternBuilder requestPatternBuilder) {
        RequestPattern requestPattern = requestPatternBuilder.build();
        VerificationResult result = this.admin.countRequestsMatching(requestPattern);
        result.assertRequestJournalEnabled();
        int actualCount = result.getCount();
        if (!expectedCount.match(actualCount)) {
            throw actualCount == 0 ? this.verificationExceptionForNearMisses(requestPatternBuilder, requestPattern) : new VerificationException(requestPattern, expectedCount, actualCount);
        }
    }

    private VerificationException verificationExceptionForNearMisses(RequestPatternBuilder requestPatternBuilder, RequestPattern requestPattern) {
        List<NearMiss> nearMisses = WireMock.findNearMissesFor(requestPatternBuilder);
        if (nearMisses.size() > 0) {
            Diff diff = new Diff(requestPattern, nearMisses.get(0).getRequest());
            return VerificationException.forUnmatchedRequestPattern(diff);
        }
        return new VerificationException(requestPattern, this.find(RequestPatternBuilder.allRequests()));
    }

    public static void verify(RequestPatternBuilder requestPatternBuilder) {
        defaultInstance.get().verifyThat(requestPatternBuilder);
    }

    public static void verify(int count, RequestPatternBuilder requestPatternBuilder) {
        defaultInstance.get().verifyThat(count, requestPatternBuilder);
    }

    public static void verify(CountMatchingStrategy countMatchingStrategy, RequestPatternBuilder requestPatternBuilder) {
        defaultInstance.get().verifyThat(countMatchingStrategy, requestPatternBuilder);
    }

    public List<LoggedRequest> find(RequestPatternBuilder requestPatternBuilder) {
        FindRequestsResult result = this.admin.findRequestsMatching(requestPatternBuilder.build());
        result.assertRequestJournalEnabled();
        return result.getRequests();
    }

    public static List<LoggedRequest> findAll(RequestPatternBuilder requestPatternBuilder) {
        return defaultInstance.get().find(requestPatternBuilder);
    }

    public static RequestPatternBuilder getRequestedFor(UrlPattern urlPattern) {
        return new RequestPatternBuilder(RequestMethod.GET, urlPattern);
    }

    public static RequestPatternBuilder postRequestedFor(UrlPattern urlPattern) {
        return new RequestPatternBuilder(RequestMethod.POST, urlPattern);
    }

    public static RequestPatternBuilder putRequestedFor(UrlPattern urlPattern) {
        return new RequestPatternBuilder(RequestMethod.PUT, urlPattern);
    }

    public static RequestPatternBuilder deleteRequestedFor(UrlPattern urlPattern) {
        return new RequestPatternBuilder(RequestMethod.DELETE, urlPattern);
    }

    public static RequestPatternBuilder patchRequestedFor(UrlPattern urlPattern) {
        return new RequestPatternBuilder(RequestMethod.PATCH, urlPattern);
    }

    public static RequestPatternBuilder headRequestedFor(UrlPattern urlPattern) {
        return new RequestPatternBuilder(RequestMethod.HEAD, urlPattern);
    }

    public static RequestPatternBuilder optionsRequestedFor(UrlPattern urlPattern) {
        return new RequestPatternBuilder(RequestMethod.OPTIONS, urlPattern);
    }

    public static RequestPatternBuilder traceRequestedFor(UrlPattern urlPattern) {
        return new RequestPatternBuilder(RequestMethod.TRACE, urlPattern);
    }

    public static RequestPatternBuilder requestMadeFor(String customMatcherName, Parameters parameters) {
        return RequestPatternBuilder.forCustomMatcher(customMatcherName, parameters);
    }

    public static LocalRequestPatternBuilder requestMadeFor(RequestMatcher requestMatcher) {
        return LocalRequestPatternBuilder.forCustomMatcher(requestMatcher);
    }

    public static void setGlobalFixedDelay(int milliseconds) {
        defaultInstance.get().setGlobalFixedDelayVariable(milliseconds);
    }

    public void setGlobalFixedDelayVariable(int milliseconds) {
        GlobalSettings settings = this.globalSettingsHolder.get().copy();
        settings.setFixedDelay(milliseconds);
        this.updateGlobalSettings(settings);
    }

    public static void setGlobalRandomDelay(DelayDistribution distribution) {
        defaultInstance.get().setGlobalRandomDelayVariable(distribution);
    }

    public void setGlobalRandomDelayVariable(DelayDistribution distribution) {
        GlobalSettings settings = this.globalSettingsHolder.get().copy();
        settings.setDelayDistribution(distribution);
        this.updateGlobalSettings(settings);
    }

    private void updateGlobalSettings(GlobalSettings settings) {
        this.globalSettingsHolder.replaceWith(settings);
        this.admin.updateGlobalSettings(settings);
    }

    public void shutdown() {
        this.admin.shutdownServer();
    }

    public static void shutdownServer() {
        defaultInstance.get().shutdown();
    }

    public static List<NearMiss> findNearMissesForAllUnmatched() {
        return defaultInstance.get().findNearMissesForAllUnmatchedRequests();
    }

    public List<NearMiss> findNearMissesForAllUnmatchedRequests() {
        FindNearMissesResult nearMissesResult = this.admin.findNearMissesForUnmatchedRequests();
        return nearMissesResult.getNearMisses();
    }

    public static List<LoggedRequest> findUnmatchedRequests() {
        return defaultInstance.get().findAllUnmatchedRequests();
    }

    public List<LoggedRequest> findAllUnmatchedRequests() {
        FindRequestsResult unmatchedResult = this.admin.findUnmatchedRequests();
        return unmatchedResult.getRequests();
    }

    public static List<NearMiss> findNearMissesFor(LoggedRequest loggedRequest) {
        return defaultInstance.get().findTopNearMissesFor(loggedRequest);
    }

    public List<NearMiss> findTopNearMissesFor(LoggedRequest loggedRequest) {
        FindNearMissesResult nearMissesResult = this.admin.findTopNearMissesFor(loggedRequest);
        return nearMissesResult.getNearMisses();
    }

    public static List<NearMiss> findNearMissesFor(RequestPatternBuilder requestPatternBuilder) {
        return defaultInstance.get().findAllNearMissesFor(requestPatternBuilder);
    }

    public List<NearMiss> findAllNearMissesFor(RequestPatternBuilder requestPatternBuilder) {
        FindNearMissesResult nearMissesResult = this.admin.findTopNearMissesFor(requestPatternBuilder.build());
        return nearMissesResult.getNearMisses();
    }
}

