/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.client;

import com.github.tomakehurst.wiremock.client.CountMatchingStrategy;
import com.github.tomakehurst.wiremock.client.HttpAdminClient;
import com.github.tomakehurst.wiremock.client.LocalMappingBuilder;
import com.github.tomakehurst.wiremock.client.LocalRequestPatternBuilder;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.UrlMatchingStrategy;
import com.github.tomakehurst.wiremock.client.ValueMatchingStrategy;
import com.github.tomakehurst.wiremock.client.VerificationException;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.global.GlobalSettings;
import com.github.tomakehurst.wiremock.global.RequestDelaySpec;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.matching.RequestMatcher;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.stubbing.ListStubMappingsResult;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.verification.FindRequestsResult;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.github.tomakehurst.wiremock.verification.VerificationResult;
import java.util.List;
import org.skyscreamer.jsonassert.JSONCompareMode;

public class WireMock {
    private static final int DEFAULT_PORT = 8080;
    private static final String DEFAULT_HOST = "localhost";
    private final Admin admin;
    private static ThreadLocal<WireMock> defaultInstance = new ThreadLocal<WireMock>(){

        @Override
        protected WireMock initialValue() {
            return new WireMock();
        }
    };

    public WireMock(Admin admin) {
        this.admin = admin;
    }

    public WireMock(int port) {
        this(DEFAULT_HOST, port);
    }

    public WireMock(String host, int port) {
        this.admin = new HttpAdminClient(host, port);
    }

    public WireMock(String host, int port, String urlPathPrefix) {
        this.admin = new HttpAdminClient(host, port, urlPathPrefix);
    }

    public WireMock(String scheme, String host, int port) {
        this.admin = new HttpAdminClient(scheme, host, port);
    }

    public WireMock(String scheme, String host, int port, String urlPathPrefix) {
        this.admin = new HttpAdminClient(scheme, host, port, urlPathPrefix);
    }

    public WireMock() {
        this.admin = new HttpAdminClient(DEFAULT_HOST, 8080);
    }

    public static void givenThat(MappingBuilder mappingBuilder) {
        defaultInstance.get().register(mappingBuilder);
    }

    public static void stubFor(MappingBuilder mappingBuilder) {
        WireMock.givenThat(mappingBuilder);
    }

    public static ListStubMappingsResult listAllStubMappings() {
        return defaultInstance.get().allStubMappings();
    }

    public static void configureFor(int port) {
        defaultInstance.set(new WireMock(port));
    }

    public static void configureFor(String host, int port) {
        defaultInstance.set(new WireMock(host, port));
    }

    public static void configureFor(String host, int port, String urlPathPrefix) {
        defaultInstance.set(new WireMock(host, port, urlPathPrefix));
    }

    public static void configureFor(String scheme, String host, int port, String urlPathPrefix) {
        defaultInstance.set(new WireMock(scheme, host, port, urlPathPrefix));
    }

    public static void configureFor(String scheme, String host, int port) {
        defaultInstance.set(new WireMock(scheme, host, port));
    }

    public static void configure() {
        defaultInstance.set(new WireMock());
    }

    public void saveMappings() {
        this.admin.saveMappings();
    }

    public static void saveAllMappings() {
        defaultInstance.get().saveMappings();
    }

    public void resetMappings() {
        this.admin.resetMappings();
    }

    public static void reset() {
        defaultInstance.get().resetMappings();
    }

    public static void resetAllRequests() {
        defaultInstance.get().resetRequests();
    }

    public void resetRequests() {
        this.admin.resetRequests();
    }

    public void resetScenarios() {
        this.admin.resetScenarios();
    }

    public static void resetAllScenarios() {
        defaultInstance.get().resetScenarios();
    }

    public void resetToDefaultMappings() {
        this.admin.resetToDefaultMappings();
    }

    public static void resetToDefault() {
        defaultInstance.get().resetToDefaultMappings();
    }

    public void register(MappingBuilder mappingBuilder) {
        StubMapping mapping = mappingBuilder.build();
        this.register(mapping);
    }

    public void register(StubMapping mapping) {
        this.admin.addStubMapping(mapping);
    }

    public ListStubMappingsResult allStubMappings() {
        return this.admin.listAllStubMappings();
    }

    public static UrlMatchingStrategy urlEqualTo(String url) {
        UrlMatchingStrategy urlStrategy = new UrlMatchingStrategy();
        urlStrategy.setUrl(url);
        return urlStrategy;
    }

    public static UrlMatchingStrategy urlMatching(String url) {
        UrlMatchingStrategy urlStrategy = new UrlMatchingStrategy();
        urlStrategy.setUrlPattern(url);
        return urlStrategy;
    }

    public static UrlMatchingStrategy urlPathEqualTo(String urlPath) {
        UrlMatchingStrategy urlStrategy = new UrlMatchingStrategy();
        urlStrategy.setUrlPath(urlPath);
        return urlStrategy;
    }

    public static UrlMatchingStrategy urlPathMatching(String urlPath) {
        UrlMatchingStrategy urlStrategy = new UrlMatchingStrategy();
        urlStrategy.setUrlPathPattern(urlPath);
        return urlStrategy;
    }

    public static ValueMatchingStrategy equalTo(String value) {
        ValueMatchingStrategy headerStrategy = new ValueMatchingStrategy();
        headerStrategy.setEqualTo(value);
        return headerStrategy;
    }

    public static ValueMatchingStrategy equalToJson(String value) {
        ValueMatchingStrategy headerStrategy = new ValueMatchingStrategy();
        headerStrategy.setEqualToJson(value);
        return headerStrategy;
    }

    public static ValueMatchingStrategy equalToJson(String value, JSONCompareMode jsonCompareMode) {
        ValueMatchingStrategy valueMatchingStrategy = new ValueMatchingStrategy();
        valueMatchingStrategy.setJsonCompareMode(jsonCompareMode);
        valueMatchingStrategy.setEqualToJson(value);
        return valueMatchingStrategy;
    }

    public static ValueMatchingStrategy equalToXml(String value) {
        ValueMatchingStrategy headerStrategy = new ValueMatchingStrategy();
        headerStrategy.setEqualToXml(value);
        return headerStrategy;
    }

    public static ValueMatchingStrategy matchingXPath(String value) {
        ValueMatchingStrategy headerStrategy = new ValueMatchingStrategy();
        headerStrategy.setMatchingXPath(value);
        return headerStrategy;
    }

    public static ValueMatchingStrategy containing(String value) {
        ValueMatchingStrategy headerStrategy = new ValueMatchingStrategy();
        headerStrategy.setContains(value);
        return headerStrategy;
    }

    public static ValueMatchingStrategy matching(String value) {
        ValueMatchingStrategy headerStrategy = new ValueMatchingStrategy();
        headerStrategy.setMatches(value);
        return headerStrategy;
    }

    public static ValueMatchingStrategy notMatching(String value) {
        ValueMatchingStrategy headerStrategy = new ValueMatchingStrategy();
        headerStrategy.setDoesNotMatch(value);
        return headerStrategy;
    }

    public static ValueMatchingStrategy matchingJsonPath(String jsonPath) {
        ValueMatchingStrategy matchingStrategy = new ValueMatchingStrategy();
        matchingStrategy.setJsonMatchesPath(jsonPath);
        return matchingStrategy;
    }

    public static CountMatchingStrategy lessThan(int expected) {
        return new CountMatchingStrategy(CountMatchingStrategy.LESS_THAN, expected);
    }

    public static CountMatchingStrategy lessThanOrExactly(int expected) {
        return new CountMatchingStrategy(CountMatchingStrategy.LESS_THAN_OR_EQUAL, expected);
    }

    public static CountMatchingStrategy exactly(int expected) {
        return new CountMatchingStrategy(CountMatchingStrategy.EQUAL_TO, expected);
    }

    public static CountMatchingStrategy moreThanOrExactly(int expected) {
        return new CountMatchingStrategy(CountMatchingStrategy.GREATER_THAN_OR_EQUAL, expected);
    }

    public static CountMatchingStrategy moreThan(int expected) {
        return new CountMatchingStrategy(CountMatchingStrategy.GREATER_THAN, expected);
    }

    public static MappingBuilder get(UrlMatchingStrategy urlMatchingStrategy) {
        return new MappingBuilder(RequestMethod.GET, urlMatchingStrategy);
    }

    public static MappingBuilder post(UrlMatchingStrategy urlMatchingStrategy) {
        return new MappingBuilder(RequestMethod.POST, urlMatchingStrategy);
    }

    public static MappingBuilder put(UrlMatchingStrategy urlMatchingStrategy) {
        return new MappingBuilder(RequestMethod.PUT, urlMatchingStrategy);
    }

    public static MappingBuilder delete(UrlMatchingStrategy urlMatchingStrategy) {
        return new MappingBuilder(RequestMethod.DELETE, urlMatchingStrategy);
    }

    public static MappingBuilder patch(UrlMatchingStrategy urlMatchingStrategy) {
        return new MappingBuilder(RequestMethod.PATCH, urlMatchingStrategy);
    }

    public static MappingBuilder head(UrlMatchingStrategy urlMatchingStrategy) {
        return new MappingBuilder(RequestMethod.HEAD, urlMatchingStrategy);
    }

    public static MappingBuilder options(UrlMatchingStrategy urlMatchingStrategy) {
        return new MappingBuilder(RequestMethod.OPTIONS, urlMatchingStrategy);
    }

    public static MappingBuilder trace(UrlMatchingStrategy urlMatchingStrategy) {
        return new MappingBuilder(RequestMethod.TRACE, urlMatchingStrategy);
    }

    public static MappingBuilder any(UrlMatchingStrategy urlMatchingStrategy) {
        return new MappingBuilder(RequestMethod.ANY, urlMatchingStrategy);
    }

    public static MappingBuilder requestMatching(String customRequestMatcherName) {
        return new MappingBuilder(customRequestMatcherName, Parameters.empty());
    }

    public static MappingBuilder requestMatching(String customRequestMatcherName, Parameters parameters) {
        return new MappingBuilder(customRequestMatcherName, parameters);
    }

    public static LocalMappingBuilder requestMatching(RequestMatcher requestMatcher) {
        return new LocalMappingBuilder(requestMatcher);
    }

    public static MappingBuilder request(String method, UrlMatchingStrategy urlMatchingStrategy) {
        return new MappingBuilder(RequestMethod.fromString(method), urlMatchingStrategy);
    }

    public static ResponseDefinitionBuilder aResponse() {
        return new ResponseDefinitionBuilder();
    }

    public void verifyThat(RequestPatternBuilder requestPatternBuilder) {
        RequestPattern requestPattern = requestPatternBuilder.build();
        VerificationResult result = this.admin.countRequestsMatching(requestPattern);
        result.assertRequestJournalEnabled();
        if (result.getCount() < 1) {
            throw new VerificationException(requestPattern, this.find(RequestPatternBuilder.allRequests()));
        }
    }

    public void verifyThat(int count, RequestPatternBuilder requestPatternBuilder) {
        RequestPattern requestPattern = requestPatternBuilder.build();
        VerificationResult result = this.admin.countRequestsMatching(requestPattern);
        result.assertRequestJournalEnabled();
        if (result.getCount() != count) {
            throw new VerificationException(requestPattern, count, this.find(RequestPatternBuilder.allRequests()));
        }
    }

    public void verifyThat(CountMatchingStrategy count, RequestPatternBuilder requestPatternBuilder) {
        RequestPattern requestPattern = requestPatternBuilder.build();
        VerificationResult result = this.admin.countRequestsMatching(requestPattern);
        result.assertRequestJournalEnabled();
        if (!count.match(result.getCount())) {
            throw new VerificationException(requestPattern, count, this.find(RequestPatternBuilder.allRequests()));
        }
    }

    public static void verify(RequestPatternBuilder requestPatternBuilder) {
        defaultInstance.get().verifyThat(requestPatternBuilder);
    }

    public static void verify(int count, RequestPatternBuilder requestPatternBuilder) {
        defaultInstance.get().verifyThat(count, requestPatternBuilder);
    }

    public static void verify(CountMatchingStrategy countMatchingStrategy, RequestPatternBuilder requestPatternBuilder) {
        defaultInstance.get().verifyThat(countMatchingStrategy, requestPatternBuilder);
    }

    public List<LoggedRequest> find(RequestPatternBuilder requestPatternBuilder) {
        FindRequestsResult result = this.admin.findRequestsMatching(requestPatternBuilder.build());
        result.assertRequestJournalEnabled();
        return result.getRequests();
    }

    public static List<LoggedRequest> findAll(RequestPatternBuilder requestPatternBuilder) {
        return defaultInstance.get().find(requestPatternBuilder);
    }

    public static RequestPatternBuilder getRequestedFor(UrlMatchingStrategy urlMatchingStrategy) {
        return new RequestPatternBuilder(RequestMethod.GET, urlMatchingStrategy);
    }

    public static RequestPatternBuilder postRequestedFor(UrlMatchingStrategy urlMatchingStrategy) {
        return new RequestPatternBuilder(RequestMethod.POST, urlMatchingStrategy);
    }

    public static RequestPatternBuilder putRequestedFor(UrlMatchingStrategy urlMatchingStrategy) {
        return new RequestPatternBuilder(RequestMethod.PUT, urlMatchingStrategy);
    }

    public static RequestPatternBuilder deleteRequestedFor(UrlMatchingStrategy urlMatchingStrategy) {
        return new RequestPatternBuilder(RequestMethod.DELETE, urlMatchingStrategy);
    }

    public static RequestPatternBuilder patchRequestedFor(UrlMatchingStrategy urlMatchingStrategy) {
        return new RequestPatternBuilder(RequestMethod.PATCH, urlMatchingStrategy);
    }

    public static RequestPatternBuilder headRequestedFor(UrlMatchingStrategy urlMatchingStrategy) {
        return new RequestPatternBuilder(RequestMethod.HEAD, urlMatchingStrategy);
    }

    public static RequestPatternBuilder optionsRequestedFor(UrlMatchingStrategy urlMatchingStrategy) {
        return new RequestPatternBuilder(RequestMethod.OPTIONS, urlMatchingStrategy);
    }

    public static RequestPatternBuilder traceRequestedFor(UrlMatchingStrategy urlMatchingStrategy) {
        return new RequestPatternBuilder(RequestMethod.TRACE, urlMatchingStrategy);
    }

    public static LocalRequestPatternBuilder requestMadeFor(RequestMatcher requestMatcher) {
        return LocalRequestPatternBuilder.forCustomMatcher(requestMatcher);
    }

    public static RequestPatternBuilder requestMadeFor(String customMatcherName, Parameters parameters) {
        return RequestPatternBuilder.forCustomMatcher(customMatcherName, parameters);
    }

    public static void setGlobalFixedDelay(int milliseconds) {
        defaultInstance.get().setGlobalFixedDelayVariable(milliseconds);
    }

    public void setGlobalFixedDelayVariable(int milliseconds) {
        GlobalSettings settings = new GlobalSettings();
        settings.setFixedDelay(milliseconds);
        this.admin.updateGlobalSettings(settings);
    }

    public void addDelayBeforeProcessingRequests(int milliseconds) {
        this.admin.addSocketAcceptDelay(new RequestDelaySpec(milliseconds));
    }

    public static void addRequestProcessingDelay(int milliseconds) {
        defaultInstance.get().addDelayBeforeProcessingRequests(milliseconds);
    }

    public void shutdown() {
        this.admin.shutdownServer();
    }

    public static void shutdownServer() {
        defaultInstance.get().shutdown();
    }
}

