/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.client;

import com.github.tomakehurst.wiremock.client.LocalMappingBuilder;
import com.github.tomakehurst.wiremock.client.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.ScenarioMappingBuilder;
import com.github.tomakehurst.wiremock.client.UrlMatchingStrategy;
import com.github.tomakehurst.wiremock.client.ValueMatchingStrategy;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.RequestMatcher;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.google.common.base.Preconditions;
import java.util.UUID;

class MappingBuilder
implements LocalMappingBuilder,
ScenarioMappingBuilder {
    private RequestPatternBuilder requestPatternBuilder;
    private ResponseDefinitionBuilder responseDefBuilder;
    private Integer priority;
    private String scenarioName;
    protected String requiredScenarioState;
    protected String newScenarioState;
    private UUID id;

    public MappingBuilder(RequestMethod method, UrlMatchingStrategy urlMatchingStrategy) {
        this.requestPatternBuilder = new RequestPatternBuilder(method, urlMatchingStrategy);
    }

    public MappingBuilder(RequestMatcher requestMatcher) {
        this.requestPatternBuilder = RequestPatternBuilder.forCustomMatcher(requestMatcher);
    }

    public MappingBuilder(String customRequestMatcherName, Parameters parameters) {
        this.requestPatternBuilder = RequestPatternBuilder.forCustomMatcher(customRequestMatcherName, parameters);
    }

    @Override
    public MappingBuilder willReturn(ResponseDefinitionBuilder responseDefBuilder) {
        this.responseDefBuilder = responseDefBuilder;
        return this;
    }

    @Override
    public MappingBuilder atPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @Override
    public MappingBuilder withHeader(String key, ValueMatchingStrategy headerMatchingStrategy) {
        this.requestPatternBuilder.withHeader(key, headerMatchingStrategy);
        return this;
    }

    @Override
    public MappingBuilder withQueryParam(String key, ValueMatchingStrategy queryParamMatchingStrategy) {
        this.requestPatternBuilder.withQueryParam(key, queryParamMatchingStrategy);
        return this;
    }

    @Override
    public MappingBuilder withRequestBody(ValueMatchingStrategy bodyMatchingStrategy) {
        this.requestPatternBuilder.withRequestBody(bodyMatchingStrategy);
        return this;
    }

    @Override
    public MappingBuilder inScenario(String scenarioName) {
        Preconditions.checkArgument((scenarioName != null ? 1 : 0) != 0, (Object)"Scenario name must not be null");
        this.scenarioName = scenarioName;
        return this;
    }

    @Override
    public MappingBuilder whenScenarioStateIs(String stateName) {
        this.requiredScenarioState = stateName;
        return this;
    }

    @Override
    public MappingBuilder willSetStateTo(String stateName) {
        this.newScenarioState = stateName;
        return this;
    }

    @Override
    public MappingBuilder withId(UUID id) {
        this.id = id;
        return this;
    }

    @Override
    public StubMapping build() {
        if (this.scenarioName == null && (this.requiredScenarioState != null || this.newScenarioState != null)) {
            throw new IllegalStateException("Scenario name must be specified to require or set a new scenario state");
        }
        RequestPattern requestPattern = this.requestPatternBuilder.build();
        ResponseDefinition response = this.responseDefBuilder.build();
        StubMapping mapping = new StubMapping(requestPattern, response);
        mapping.setPriority(this.priority);
        mapping.setScenarioName(this.scenarioName);
        mapping.setRequiredScenarioState(this.requiredScenarioState);
        mapping.setNewScenarioState(this.newScenarioState);
        mapping.setUuid(this.id);
        return mapping;
    }
}

