/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.stubbing;

import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.IdGenerator;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.UniqueFilenameGenerator;
import com.github.tomakehurst.wiremock.common.VeryShortIdGenerator;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.http.CaseInsensitiveKey;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestListener;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.ValuePattern;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.verification.VerificationResult;
import java.util.Arrays;
import java.util.List;

public class StubMappingJsonRecorder
implements RequestListener {
    private final FileSource mappingsFileSource;
    private final FileSource filesFileSource;
    private final Admin admin;
    private final List<CaseInsensitiveKey> headersToMatch;
    private IdGenerator idGenerator;

    public StubMappingJsonRecorder(FileSource mappingsFileSource, FileSource filesFileSource, Admin admin, List<CaseInsensitiveKey> headersToMatch) {
        this.mappingsFileSource = mappingsFileSource;
        this.filesFileSource = filesFileSource;
        this.admin = admin;
        this.headersToMatch = headersToMatch;
        this.idGenerator = new VeryShortIdGenerator();
    }

    @Override
    public void requestReceived(Request request, Response response) {
        RequestPattern requestPattern = this.buildRequestPatternFrom(request);
        if (this.requestNotAlreadyReceived(requestPattern) && response.isFromProxy()) {
            LocalNotifier.notifier().info(String.format("Recording mappings for %s", request.getUrl()));
            this.writeToMappingAndBodyFile(request, response, requestPattern);
        } else {
            LocalNotifier.notifier().info(String.format("Not recording mapping for %s as this has already been received", request.getUrl()));
        }
    }

    private RequestPattern buildRequestPatternFrom(Request request) {
        String body;
        RequestPattern requestPattern = new RequestPattern(request.getMethod(), request.getUrl());
        if (!this.headersToMatch.isEmpty()) {
            for (HttpHeader header : request.getHeaders().all()) {
                if (!this.headersToMatch.contains(header.caseInsensitiveKey())) continue;
                requestPattern.addHeader(header.key(), ValuePattern.equalTo(header.firstValue()));
            }
        }
        if (!(body = request.getBodyAsString()).isEmpty()) {
            ValuePattern bodyPattern = ValuePattern.equalTo(request.getBodyAsString());
            requestPattern.setBodyPatterns(Arrays.asList(bodyPattern));
        }
        return requestPattern;
    }

    private void writeToMappingAndBodyFile(Request request, Response response, RequestPattern requestPattern) {
        String fileId = this.idGenerator.generate();
        String mappingFileName = UniqueFilenameGenerator.generate(request, "mapping", fileId);
        String bodyFileName = UniqueFilenameGenerator.generate(request, "body", fileId);
        ResponseDefinition responseToWrite = new ResponseDefinition();
        responseToWrite.setStatus(response.getStatus());
        responseToWrite.setBodyFileName(bodyFileName);
        if (response.getHeaders().size() > 0) {
            responseToWrite.setHeaders(response.getHeaders());
        }
        StubMapping mapping = new StubMapping(requestPattern, responseToWrite);
        this.filesFileSource.writeBinaryFile(bodyFileName, response.getBody());
        this.mappingsFileSource.writeTextFile(mappingFileName, Json.write(mapping));
    }

    private boolean requestNotAlreadyReceived(RequestPattern requestPattern) {
        VerificationResult verificationResult = this.admin.countRequestsMatching(requestPattern);
        verificationResult.assertRequestJournalEnabled();
        return verificationResult.getCount() <= 1;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }
}

