/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.junit;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit.Stubbing;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import java.util.List;
import org.junit.rules.MethodRule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class WireMockClassRule
implements MethodRule,
TestRule,
Stubbing {
    private final Options options;
    private final WireMockServer wireMockServer;
    private WireMock wireMock;

    public WireMockClassRule(Options options) {
        this.options = options;
        this.wireMockServer = new WireMockServer(options);
    }

    public WireMockClassRule(int port, Integer httpsPort) {
        this(WireMockConfiguration.wireMockConfig().port(port).httpsPort(httpsPort));
    }

    public WireMockClassRule(int port) {
        this(WireMockConfiguration.wireMockConfig().port(port));
    }

    public WireMockClassRule() {
        this(WireMockConfiguration.wireMockConfig());
    }

    public Statement apply(Statement base, FrameworkMethod method, Object target) {
        return this.apply(base, null);
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                if (WireMockClassRule.this.wireMockServer.isRunning()) {
                    try {
                        WireMockClassRule.this.before();
                        base.evaluate();
                    }
                    finally {
                        WireMockClassRule.this.after();
                        WireMockClassRule.this.wireMock.resetMappings();
                    }
                }
                WireMockClassRule.this.wireMockServer.start();
                WireMockClassRule.this.wireMock = new WireMock("localhost", WireMockClassRule.this.port());
                WireMock.configureFor("localhost", WireMockClassRule.this.port());
                try {
                    WireMockClassRule.this.before();
                    base.evaluate();
                }
                finally {
                    WireMockClassRule.this.after();
                    WireMockClassRule.this.wireMockServer.stop();
                }
            }
        };
    }

    protected void before() {
    }

    protected void after() {
    }

    @Override
    public void givenThat(MappingBuilder mappingBuilder) {
        this.wireMock.register(mappingBuilder);
    }

    @Override
    public void stubFor(MappingBuilder mappingBuilder) {
        this.givenThat(mappingBuilder);
    }

    @Override
    public void verify(RequestPatternBuilder requestPatternBuilder) {
        this.wireMock.verifyThat(requestPatternBuilder);
    }

    @Override
    public void verify(int count, RequestPatternBuilder requestPatternBuilder) {
        this.wireMock.verifyThat(count, requestPatternBuilder);
    }

    @Override
    public List<LoggedRequest> findAll(RequestPatternBuilder requestPatternBuilder) {
        return this.wireMock.find(requestPatternBuilder);
    }

    @Override
    public void setGlobalFixedDelay(int milliseconds) {
        this.wireMock.setGlobalFixedDelayVariable(milliseconds);
    }

    @Override
    public void addRequestProcessingDelay(int milliseconds) {
        this.wireMock.addDelayBeforeProcessingRequests(milliseconds);
    }

    public int port() {
        return this.wireMockServer.port();
    }

    public int httpsPort() {
        return this.wireMockServer.httpsPort();
    }
}

