/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.mapping;

import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.mapping.AbstractRequestHandler;
import com.github.tomakehurst.wiremock.mapping.Mappings;
import com.github.tomakehurst.wiremock.mapping.Request;
import com.github.tomakehurst.wiremock.mapping.ResponseDefinition;
import com.github.tomakehurst.wiremock.servlet.ResponseRenderer;

public class MockServiceRequestHandler
extends AbstractRequestHandler {
    private final Mappings mappings;
    private final boolean browserProxyingEnabled;

    public MockServiceRequestHandler(Mappings mappings, ResponseRenderer responseRenderer, boolean browserProxyingEnabled) {
        super(responseRenderer);
        this.mappings = mappings;
        this.browserProxyingEnabled = browserProxyingEnabled;
    }

    @Override
    public ResponseDefinition handleRequest(Request request) {
        LocalNotifier.notifier().info("Received request to " + request.getUrl());
        ResponseDefinition responseDef = this.mappings.serveFor(request);
        if (!responseDef.wasConfigured() && request.isBrowserProxyRequest() && this.browserProxyingEnabled) {
            return ResponseDefinition.browserProxy(request);
        }
        return responseDef;
    }
}

