/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.mapping;

import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.IdGenerator;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.VeryShortIdGenerator;
import com.github.tomakehurst.wiremock.mapping.Json;
import com.github.tomakehurst.wiremock.mapping.Request;
import com.github.tomakehurst.wiremock.mapping.RequestListener;
import com.github.tomakehurst.wiremock.mapping.RequestPattern;
import com.github.tomakehurst.wiremock.mapping.RequestResponseMapping;
import com.github.tomakehurst.wiremock.mapping.Response;
import com.github.tomakehurst.wiremock.mapping.ResponseDefinition;
import com.github.tomakehurst.wiremock.verification.RequestJournal;
import java.net.URI;

public class MappingFileWriterListener
implements RequestListener {
    private final FileSource mappingsFileSource;
    private final FileSource filesFileSource;
    private final RequestJournal requestJournal;
    private IdGenerator idGenerator;

    public MappingFileWriterListener(FileSource mappingsFileSource, FileSource filesFileSource, RequestJournal requestJournal) {
        this.mappingsFileSource = mappingsFileSource;
        this.filesFileSource = filesFileSource;
        this.requestJournal = requestJournal;
        this.idGenerator = new VeryShortIdGenerator();
    }

    @Override
    public void requestReceived(Request request, Response response) {
        RequestPattern requestPattern = new RequestPattern(request.getMethod(), request.getUrl());
        if (this.requestNotAlreadyReceived(requestPattern) && response.isFromProxy()) {
            LocalNotifier.notifier().info(String.format("Recording mappings for %s", request.getUrl()));
            this.writeToMappingAndBodyFile(request, response, requestPattern);
        } else {
            LocalNotifier.notifier().info(String.format("Not recording mapping for %s as this has already been received", request.getUrl()));
        }
    }

    private void writeToMappingAndBodyFile(Request request, Response response, RequestPattern requestPattern) {
        String fileId = this.idGenerator.generate();
        String mappingFileName = this.generateNewUniqueFileNameFromRequest(request, "mapping", fileId);
        String bodyFileName = this.generateNewUniqueFileNameFromRequest(request, "body", fileId);
        ResponseDefinition responseToWrite = new ResponseDefinition();
        responseToWrite.setStatus(response.getStatus());
        responseToWrite.setBodyFileName(bodyFileName);
        if (response.getHeaders().size() > 0) {
            responseToWrite.setHeaders(response.getHeaders());
        }
        RequestResponseMapping mapping = new RequestResponseMapping(requestPattern, responseToWrite);
        this.filesFileSource.writeBinaryFile(bodyFileName, response.getBody());
        this.mappingsFileSource.writeTextFile(mappingFileName, Json.write(mapping));
    }

    private boolean requestNotAlreadyReceived(RequestPattern requestPattern) {
        return this.requestJournal.countRequestsMatching(requestPattern) <= 1;
    }

    private String generateNewUniqueFileNameFromRequest(Request request, String prefix, String id) {
        URI uri = URI.create(request.getUrl());
        String[] pathNodes = uri.getPath().split("/");
        StringBuilder sb = new StringBuilder(prefix).append("-");
        if (pathNodes.length > 1) {
            sb.append(pathNodes[pathNodes.length - 2]).append("-");
        }
        sb.append(pathNodes[pathNodes.length - 1]).append("-").append(id).append(".json");
        return sb.toString();
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }
}

