/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.Notifier;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;

public class Log4jNotifier
implements Notifier {
    private static final Logger log = Logger.getLogger(Log4jNotifier.class);
    private static ConsoleAppender appender = new ConsoleAppender();

    public Log4jNotifier() {
        this.setVerbose(false);
    }

    public void setVerbose(boolean verbose) {
        if (verbose) {
            appender.setThreshold((Priority)Level.INFO);
        } else {
            appender.setThreshold((Priority)Level.ERROR);
        }
        appender.activateOptions();
    }

    @Override
    public void info(String message) {
        log.info((Object)message);
    }

    @Override
    public void error(String message) {
        log.error((Object)message);
    }

    @Override
    public void error(String message, Throwable t) {
        log.error((Object)message, t);
    }

    static {
        appender.setLayout((Layout)new PatternLayout("%d{yyyy-MM-dd HH:mm:ss} %m%n"));
        appender.activateOptions();
        appender.setThreshold((Priority)Level.ERROR);
        Logger.getRootLogger().addAppender((Appender)appender);
        Logger.getRootLogger().setLevel(Level.TRACE);
    }
}

