/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.servlet;

import com.github.tomakehurst.wiremock.WireMockApp;
import com.github.tomakehurst.wiremock.common.Log4jNotifier;
import com.github.tomakehurst.wiremock.common.ServletContextFileSource;
import com.github.tomakehurst.wiremock.mapping.AdminRequestHandler;
import com.github.tomakehurst.wiremock.mapping.MockServiceRequestHandler;
import com.github.tomakehurst.wiremock.standalone.JsonFileMappingsLoader;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class WireMockWebContextListener
implements ServletContextListener {
    private static final String APP_CONTEXT_KEY = "WireMockApp";
    private static final String FILE_SOURCE_ROOT_KEY = "WireMockFileSourceRoot";

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext context = sce.getServletContext();
        String fileSourceRoot = context.getInitParameter(FILE_SOURCE_ROOT_KEY);
        ServletContextFileSource fileSource = new ServletContextFileSource(context, fileSourceRoot);
        Log4jNotifier notifier = new Log4jNotifier();
        notifier.setVerbose(true);
        WireMockApp wireMockApp = new WireMockApp(fileSource, notifier, false);
        context.setAttribute(APP_CONTEXT_KEY, (Object)wireMockApp);
        context.setAttribute(MockServiceRequestHandler.class.getName(), (Object)wireMockApp.getMockServiceRequestHandler());
        context.setAttribute(AdminRequestHandler.class.getName(), (Object)wireMockApp.getAdminRequestHandler());
        wireMockApp.loadMappingsUsing(new JsonFileMappingsLoader(fileSource.child("mappings")));
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

