/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class HttpClientFactory {
    public static HttpClient createClient(int maxConnections, int timeoutMilliseconds) {
        ThreadSafeClientConnManager connectionManager = new ThreadSafeClientConnManager();
        connectionManager.setMaxTotal(maxConnections);
        connectionManager.setDefaultMaxPerRoute(maxConnections);
        DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)connectionManager);
        HttpParams params = client.getParams();
        params.setParameter("http.protocol.handle-redirects", (Object)false);
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)timeoutMilliseconds);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)timeoutMilliseconds);
        return client;
    }

    public static HttpClient createClient(int timeoutMilliseconds) {
        return HttpClientFactory.createClient(50, timeoutMilliseconds);
    }

    public static HttpClient createClient() {
        return HttpClientFactory.createClient(30000);
    }
}

