/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.verification.diff;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.ListOrSingle;
import com.github.tomakehurst.wiremock.common.Urls;
import com.github.tomakehurst.wiremock.common.url.PathParams;
import com.github.tomakehurst.wiremock.common.url.PathTemplate;
import com.github.tomakehurst.wiremock.common.xml.Xml;
import com.github.tomakehurst.wiremock.http.Body;
import com.github.tomakehurst.wiremock.http.Cookie;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.QueryParameter;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.matching.BinaryEqualToPattern;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.EqualToJsonPattern;
import com.github.tomakehurst.wiremock.matching.EqualToPattern;
import com.github.tomakehurst.wiremock.matching.EqualToXmlPattern;
import com.github.tomakehurst.wiremock.matching.MultiValuePattern;
import com.github.tomakehurst.wiremock.matching.MultipartValuePattern;
import com.github.tomakehurst.wiremock.matching.MultipleMatchMultiValuePattern;
import com.github.tomakehurst.wiremock.matching.PathPattern;
import com.github.tomakehurst.wiremock.matching.RequestMatcherExtension;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.SingleMatchMultiValuePattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.UrlPathPattern;
import com.github.tomakehurst.wiremock.matching.UrlPathTemplatePattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.verification.diff.DiffLine;
import com.github.tomakehurst.wiremock.verification.diff.InlineCustomMatcherLine;
import com.github.tomakehurst.wiremock.verification.diff.JUnitStyleDiffRenderer;
import com.github.tomakehurst.wiremock.verification.diff.NamedCustomMatcherLine;
import com.github.tomakehurst.wiremock.verification.diff.SectionDelimiter;
import com.github.tomakehurst.wiremock.verification.diff.SpacerLine;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import wiremock.com.google.common.base.MoreObjects;
import wiremock.com.google.common.collect.ImmutableList;
import wiremock.org.apache.commons.lang3.StringUtils;

public class Diff {
    private final String stubMappingName;
    private final RequestPattern requestPattern;
    private final Request request;
    private final String scenarioName;
    private final String scenarioState;
    private final String expectedScenarioState;

    public Diff(RequestPattern expected, Request actual) {
        this.requestPattern = expected;
        this.request = actual;
        this.stubMappingName = null;
        this.scenarioName = null;
        this.scenarioState = null;
        this.expectedScenarioState = null;
    }

    public Diff(StubMapping expected, Request actual) {
        this(expected, actual, null);
    }

    public Diff(StubMapping expected, Request actual, String scenarioState) {
        this.requestPattern = expected.getRequest();
        this.request = actual;
        this.stubMappingName = expected.getName();
        this.scenarioName = expected.getScenarioName();
        this.scenarioState = scenarioState;
        this.expectedScenarioState = expected.getRequiredScenarioState();
    }

    public String toString() {
        return new JUnitStyleDiffRenderer().render(this);
    }

    public List<DiffLine<?>> getLines() {
        return this.getLines(Collections.emptyMap());
    }

    public List<DiffLine<?>> getLines(Map<String, RequestMatcherExtension> customMatcherExtensions) {
        DiffLine<Object> section;
        String operator;
        ImmutableList.Builder<DiffLine<?>> builder = ImmutableList.builder();
        if (this.requestPattern.getHost() != null) {
            String hostOperator = this.generateOperatorString(this.requestPattern.getHost(), "");
            String printedHostPatternValue = hostOperator + this.requestPattern.getHost().getExpected();
            DiffLine<String> hostSection = new DiffLine<String>("Host", this.requestPattern.getHost(), this.request.getHost(), printedHostPatternValue.trim());
            builder.add((Object)hostSection);
        }
        if (this.requestPattern.getPort() != null) {
            StringValuePattern expectedPort = WireMock.equalTo(String.valueOf(this.requestPattern.getPort()));
            String actualPort = String.valueOf(this.request.getPort());
            DiffLine<String> portSection = new DiffLine<String>("Port", expectedPort, actualPort, expectedPort.getExpected());
            builder.add((Object)portSection);
        }
        if (this.requestPattern.getScheme() != null) {
            StringValuePattern expectedScheme = WireMock.equalTo(String.valueOf(this.requestPattern.getScheme()));
            DiffLine<String> schemeSection = new DiffLine<String>("Scheme", expectedScheme, this.request.getScheme(), this.requestPattern.getScheme());
            builder.add((Object)schemeSection);
        }
        DiffLine<RequestMethod> methodSection = new DiffLine<RequestMethod>("HTTP method", this.requestPattern.getMethod(), this.request.getMethod(), this.requestPattern.getMethod().getName());
        builder.add((Object)methodSection);
        UrlPattern urlPattern = MoreObjects.firstNonNull(this.requestPattern.getUrlMatcher(), WireMock.anyUrl());
        String printedUrlPattern = this.generatePrintedUrlPattern(urlPattern);
        DiffLine<String> urlSection = new DiffLine<String>("URL", urlPattern, this.request.getUrl(), printedUrlPattern);
        builder.add((Object)urlSection);
        builder.add((Object)SpacerLine.SPACER);
        this.addHeaderSection(this.requestPattern.combineBasicAuthAndOtherHeaders(), this.request.getHeaders(), builder);
        Map<String, StringValuePattern> pathParameters = this.requestPattern.getPathParameters();
        if (urlPattern instanceof UrlPathTemplatePattern && pathParameters != null && !pathParameters.isEmpty() && !urlSection.isForNonMatch()) {
            UrlPathTemplatePattern urlPathTemplatePattern = (UrlPathTemplatePattern)this.requestPattern.getUrlMatcher();
            PathTemplate pathTemplate = urlPathTemplatePattern.getPathTemplate();
            PathParams requestPathParameterValues = pathTemplate.parse(this.request.getUrl());
            for (Map.Entry entry : requestPathParameterValues.entrySet()) {
                String string = (String)entry.getKey();
                String parameterValue = string + ": " + (String)entry.getValue();
                StringValuePattern pattern = pathParameters.get(string);
                operator = this.generateOperatorString(pattern, " = ");
                section = new DiffLine<CallSite>("Path parameter", pattern, (CallSite)((Object)parameterValue), "Path parameter: " + string + operator + (String)pattern.getValue());
                builder.add((Object)section);
            }
            builder.add((Object)SpacerLine.SPACER);
        }
        boolean anyQueryParams = false;
        if (this.requestPattern.getQueryParameters() != null) {
            Map<String, QueryParameter> requestQueryParams = Urls.splitQuery(URI.create(this.request.getUrl()));
            for (Map.Entry entry : this.requestPattern.getQueryParameters().entrySet()) {
                String string = (String)entry.getKey();
                MultiValuePattern multiValuePattern = (MultiValuePattern)entry.getValue();
                QueryParameter queryParameter = MoreObjects.firstNonNull(requestQueryParams.get(string), QueryParameter.absent(string));
                String operator2 = this.generateOperatorStringForMultiValuePattern(multiValuePattern, " = ");
                DiffLine<QueryParameter> section2 = new DiffLine<QueryParameter>("Query", multiValuePattern, queryParameter, "Query: " + string + operator2 + multiValuePattern.getExpected());
                builder.add((Object)section2);
                anyQueryParams = true;
            }
        }
        if (anyQueryParams) {
            builder.add((Object)SpacerLine.SPACER);
        }
        boolean anyCookieSections = false;
        if (this.requestPattern.getCookies() != null) {
            Map cookies = MoreObjects.firstNonNull(this.request.getCookies(), Collections.emptyMap());
            for (Map.Entry<String, StringValuePattern> entry : this.requestPattern.getCookies().entrySet()) {
                String string = entry.getKey();
                StringValuePattern pattern = entry.getValue();
                Cookie cookie = MoreObjects.firstNonNull((Cookie)cookies.get(string), Cookie.absent());
                operator = this.generateOperatorString(pattern, "=");
                section = new DiffLine<String>("Cookie", pattern, cookie.isPresent() ? cookie.getValue() : "", "Cookie: " + string + operator + (String)pattern.getValue());
                builder.add((Object)section);
                anyCookieSections = true;
            }
        }
        if (anyCookieSections) {
            builder.add((Object)SpacerLine.SPACER);
        }
        List<ContentPattern<?>> bodyPatterns = this.requestPattern.getBodyPatterns();
        this.addBodySection(bodyPatterns, new Body(this.request.getBody()), builder);
        List<MultipartValuePattern> list = this.requestPattern.getMultipartPatterns();
        if (list != null && !list.isEmpty()) {
            for (MultipartValuePattern multipartValuePattern : list) {
                if (!this.request.isMultipart()) {
                    builder.add((Object)new SectionDelimiter("[Multipart request body]", ""));
                    continue;
                }
                if (multipartValuePattern.match(this.request).isExactMatch()) continue;
                for (Request.Part part : this.request.getParts()) {
                    builder.add((Object)SpacerLine.SPACER);
                    String patternPartName = multipartValuePattern.getName() == null ? "" : ": " + multipartValuePattern.getName();
                    String partName = part.getName() == null ? "" : part.getName();
                    builder.add((Object)new SectionDelimiter("[Multipart" + patternPartName + "]", "[" + partName + "]"));
                    builder.add((Object)SpacerLine.SPACER);
                    if (!multipartValuePattern.match(part).isExactMatch()) {
                        this.addHeaderSection(multipartValuePattern.getHeaders(), part.getHeaders(), builder);
                        this.addBodySection(multipartValuePattern.getBodyPatterns(), part.getBody(), builder);
                        builder.add((Object)SpacerLine.SPACER);
                    }
                    builder.add((Object)new SectionDelimiter("[/Multipart]", "[/" + partName + "]"));
                    builder.add((Object)SpacerLine.SPACER);
                }
            }
        }
        if (this.requestPattern.hasInlineCustomMatcher()) {
            InlineCustomMatcherLine inlineCustomMatcherLine = new InlineCustomMatcherLine(this.requestPattern.getMatcher(), this.request);
            builder.add((Object)inlineCustomMatcherLine);
        }
        if (this.requestPattern.hasNamedCustomMatcher()) {
            RequestMatcherExtension requestMatcherExtension = customMatcherExtensions.get(this.requestPattern.getCustomMatcher().getName());
            if (requestMatcherExtension != null) {
                NamedCustomMatcherLine namedCustomMatcherLine = new NamedCustomMatcherLine(requestMatcherExtension, this.requestPattern.getCustomMatcher().getParameters(), this.request);
                builder.add((Object)namedCustomMatcherLine);
            } else {
                builder.add((Object)new SectionDelimiter("[custom matcher: " + this.requestPattern.getCustomMatcher().getName() + "]"));
            }
        }
        if (this.scenarioName != null) {
            builder.add((Object)new DiffLine<String>("Scenario", new EqualToPattern(this.expectedScenarioState), Diff.buildScenarioLine(this.scenarioName, this.scenarioState), Diff.buildScenarioLine(this.scenarioName, this.expectedScenarioState)));
        }
        return builder.build();
    }

    private static String buildScenarioLine(String scenarioName, String scenarioState) {
        return "[Scenario '" + scenarioName + "' state: " + scenarioState + "]";
    }

    private void addHeaderSection(Map<String, MultiValuePattern> headerPatterns, HttpHeaders headers, ImmutableList.Builder<DiffLine<?>> builder) {
        boolean anyHeaderSections = false;
        if (headerPatterns != null && !headerPatterns.isEmpty()) {
            anyHeaderSections = true;
            for (String key : headerPatterns.keySet()) {
                HttpHeader header = headers.getHeader(key);
                MultiValuePattern headerPattern = headerPatterns.get(header.key());
                String operator = this.generateOperatorStringForMultiValuePattern(headerPattern, "");
                String expected = StringUtils.isEmpty(headerPattern.getExpected()) ? "" : ": " + headerPattern.getExpected();
                String printedPatternValue = header.key() + operator + expected;
                DiffLine<HttpHeader> section = new DiffLine<HttpHeader>("Header", headerPattern, header, printedPatternValue);
                builder.add((Object)section);
            }
        }
        if (anyHeaderSections) {
            builder.add((Object)SpacerLine.SPACER);
        }
    }

    private void addBodySection(List<ContentPattern<?>> bodyPatterns, Body body, ImmutableList.Builder<DiffLine<?>> builder) {
        if (bodyPatterns != null && !bodyPatterns.isEmpty()) {
            for (ContentPattern<?> pattern : bodyPatterns) {
                String formattedBody = Diff.formatIfJsonOrXml(pattern, body);
                if (PathPattern.class.isAssignableFrom(pattern.getClass())) {
                    PathPattern pathPattern = (PathPattern)pattern;
                    if (!pathPattern.isSimple()) {
                        ListOrSingle<String> expressionResult = pathPattern.getExpressionResult(body.asString());
                        String expressionResultString = expressionResult != null && !expressionResult.isEmpty() ? expressionResult.toString() : null;
                        String printedExpectedValue = pathPattern.getExpected() + " [" + pathPattern.getValuePattern().getName() + "] " + pathPattern.getValuePattern().getExpected();
                        if (expressionResultString != null) {
                            builder.add((Object)new DiffLine<String>("Body", pathPattern.getValuePattern(), expressionResultString, printedExpectedValue));
                            continue;
                        }
                        builder.add((Object)new DiffLine<String>("Body", pathPattern, formattedBody, printedExpectedValue));
                        continue;
                    }
                    builder.add((Object)new DiffLine<String>("Body", pathPattern, formattedBody, pattern.getExpected()));
                    continue;
                }
                if (StringValuePattern.class.isAssignableFrom(pattern.getClass())) {
                    StringValuePattern stringValuePattern = (StringValuePattern)pattern;
                    String printedPatternValue = "[" + pattern.getName() + "]\n" + pattern.getExpected();
                    builder.add((Object)new DiffLine<CallSite>("Body", stringValuePattern, (CallSite)((Object)("\n" + formattedBody)), printedPatternValue));
                    continue;
                }
                BinaryEqualToPattern nonStringPattern = (BinaryEqualToPattern)pattern;
                builder.add((Object)new DiffLine<byte[]>("Body", nonStringPattern, formattedBody.getBytes(), pattern.getExpected()));
            }
        }
    }

    private String generatePrintedUrlPattern(UrlPattern urlPattern) {
        Object matchPart = urlPattern instanceof UrlPathTemplatePattern ? "path template" : (urlPattern instanceof UrlPathPattern ? "path" : "") + (urlPattern.isRegex() ? " regex" : "");
        matchPart = ((String)matchPart).trim();
        return ((String)matchPart).isEmpty() ? urlPattern.getExpected() : "[" + (String)matchPart + "] " + urlPattern.getExpected();
    }

    private String generateOperatorString(ContentPattern<?> pattern, String defaultValue) {
        return Diff.isAnEqualToPattern(pattern) ? defaultValue : " [" + pattern.getName() + "] ";
    }

    private String generateOperatorStringForMultiValuePattern(MultiValuePattern valuePattern, String defaultValue) {
        if (valuePattern instanceof MultipleMatchMultiValuePattern) {
            return ((MultipleMatchMultiValuePattern)valuePattern).getOperator() + "[" + valuePattern.getName() + "]";
        }
        return Diff.isAnEqualToPattern(((SingleMatchMultiValuePattern)valuePattern).getValuePattern()) ? defaultValue : " [" + valuePattern.getName() + "] ";
    }

    public String getStubMappingName() {
        return this.stubMappingName;
    }

    private static String formatIfJsonOrXml(ContentPattern<?> pattern, Body body) {
        if (body == null || body.isAbsent()) {
            return "";
        }
        try {
            return pattern.getClass().equals(EqualToJsonPattern.class) ? Json.prettyPrint(Json.write(body.asJson())) : (pattern.getClass().equals(EqualToXmlPattern.class) ? Xml.prettyPrint(body.asString()) : (pattern.getClass().equals(BinaryEqualToPattern.class) ? body.asBase64() : body.asString()));
        }
        catch (Exception e) {
            return body.asString();
        }
    }

    private static boolean isAnEqualToPattern(ContentPattern<?> pattern) {
        return pattern instanceof EqualToPattern || pattern instanceof EqualToJsonPattern || pattern instanceof EqualToXmlPattern || pattern instanceof BinaryEqualToPattern;
    }
}

