/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.LogicalAnd;
import com.github.tomakehurst.wiremock.matching.LogicalOr;
import com.github.tomakehurst.wiremock.matching.StringValuePatternJsonDeserializer;
import java.lang.reflect.Constructor;
import wiremock.com.fasterxml.jackson.annotation.JsonIgnore;
import wiremock.com.fasterxml.jackson.annotation.JsonProperty;
import wiremock.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import wiremock.com.google.common.base.Objects;
import wiremock.com.google.common.base.Predicate;
import wiremock.com.google.common.collect.FluentIterable;

@JsonDeserialize(using=StringValuePatternJsonDeserializer.class)
public abstract class StringValuePattern
extends ContentPattern<String> {
    public StringValuePattern(String expectedValue) {
        super(expectedValue);
    }

    @JsonIgnore
    public boolean isPresent() {
        return !this.nullSafeIsAbsent();
    }

    public Boolean isAbsent() {
        return !this.nullSafeIsAbsent() ? null : Boolean.valueOf(true);
    }

    @JsonIgnore
    public boolean nullSafeIsAbsent() {
        return false;
    }

    public String toString() {
        return this.getName() + " " + (String)this.getValue();
    }

    @Override
    public final String getName() {
        Constructor<?> constructor = FluentIterable.from(this.getClass().getDeclaredConstructors()).firstMatch(new Predicate<Constructor<?>>(){

            @Override
            public boolean apply(Constructor<?> input) {
                return input.getParameterAnnotations().length > 0 && input.getParameterAnnotations()[0].length > 0 && input.getParameterAnnotations()[0][0] instanceof JsonProperty;
            }
        }).orNull();
        if (constructor == null) {
            throw new IllegalStateException("Constructor must have a first parameter annotated with JsonProperty(\"<operator name>\")");
        }
        JsonProperty jsonPropertyAnnotation = (JsonProperty)constructor.getParameterAnnotations()[0][0];
        return jsonPropertyAnnotation.value();
    }

    @Override
    public String getExpected() {
        return (String)this.getValue();
    }

    public LogicalAnd and(StringValuePattern other) {
        return new LogicalAnd(this, other);
    }

    public LogicalOr or(StringValuePattern other) {
        return new LogicalOr(this, other);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringValuePattern that = (StringValuePattern)o;
        return Objects.equal(this.expectedValue, that.expectedValue);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.expectedValue);
    }
}

