/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.JsonException;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.ValidationMessage;
import java.util.Set;
import wiremock.com.fasterxml.jackson.annotation.JsonProperty;
import wiremock.com.fasterxml.jackson.databind.JsonNode;

public class MatchesJsonSchemaPattern
extends StringValuePattern {
    private final JsonSchema schema;
    private final WireMock.JsonSchemaVersion schemaVersion;
    private final int schemaPropertyCount;

    public MatchesJsonSchemaPattern(String schemaJson) {
        this(schemaJson, WireMock.JsonSchemaVersion.V202012);
    }

    public MatchesJsonSchemaPattern(@JsonProperty(value="matchesJsonSchema") String schemaJson, @JsonProperty(value="schemaVersion") WireMock.JsonSchemaVersion schemaVersion) {
        super(schemaJson);
        SchemaValidatorsConfig config = new SchemaValidatorsConfig();
        config.setTypeLoose(false);
        config.setHandleNullableField(true);
        JsonSchemaFactory schemaFactory = JsonSchemaFactory.getInstance(schemaVersion.toVersionFlag());
        this.schema = schemaFactory.getSchema(schemaJson, config);
        this.schemaVersion = schemaVersion;
        this.schemaPropertyCount = Json.schemaPropertyCount(Json.read(schemaJson, JsonNode.class));
    }

    public String getMatchesJsonSchema() {
        return (String)this.expectedValue;
    }

    public WireMock.JsonSchemaVersion getSchemaVersion() {
        return this.schemaVersion;
    }

    @Override
    public String getExpected() {
        return Json.prettyPrint((String)this.getValue());
    }

    @Override
    public MatchResult match(String json) {
        JsonNode jsonNode;
        try {
            jsonNode = Json.read(json, JsonNode.class);
        }
        catch (JsonException je) {
            return MatchResult.noMatch();
        }
        final Set<ValidationMessage> validationMessages = this.schema.validate(jsonNode);
        if (validationMessages.isEmpty()) {
            return MatchResult.exactMatch();
        }
        return new MatchResult(){

            @Override
            public boolean isExactMatch() {
                return false;
            }

            @Override
            public double getDistance() {
                if (MatchesJsonSchemaPattern.this.schemaPropertyCount == 0) {
                    return 1.0;
                }
                return (double)validationMessages.size() / (double)MatchesJsonSchemaPattern.this.schemaPropertyCount;
            }
        };
    }
}

