/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.CollectorContext;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.SpecVersionDetector;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import com.networknt.schema.VersionCode;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class ContainsValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(ContainsValidator.class);
    private static final String CONTAINS_MAX = "contains.max";
    private static final String CONTAINS_MIN = "contains.min";
    private static final SpecVersion.VersionFlag DEFAULT_VERSION = SpecVersion.VersionFlag.V6;
    private final JsonSchema schema;
    private final boolean isMinV201909;
    private int min = 1;
    private int max = Integer.MAX_VALUE;

    public ContainsValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.CONTAINS, validationContext);
        this.isMinV201909 = VersionCode.MinV201909.getVersions().contains((Object)SpecVersionDetector.detectOptionalVersion(validationContext.getMetaSchema().getUri()).orElse(DEFAULT_VERSION));
        if (schemaNode.isObject() || schemaNode.isBoolean()) {
            this.schema = validationContext.newSchema(this.getValidatorType().getValue(), schemaNode, parentSchema);
            JsonNode parentSchemaNode = parentSchema.getSchemaNode();
            Optional.ofNullable(parentSchemaNode.get(ValidatorTypeCode.MAX_CONTAINS.getValue())).filter(JsonNode::canConvertToExactIntegral).ifPresent(node -> {
                this.max = node.intValue();
            });
            Optional.ofNullable(parentSchemaNode.get(ValidatorTypeCode.MIN_CONTAINS.getValue())).filter(JsonNode::canConvertToExactIntegral).ifPresent(node -> {
                this.min = node.intValue();
            });
        } else {
            this.schema = null;
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        if (null != this.schema && node.isArray()) {
            Collection<String> evaluatedItems = CollectorContext.getInstance().getEvaluatedItems();
            int actual = 0;
            int i = 0;
            for (JsonNode n : node) {
                String path;
                if (this.schema.validate(n, rootNode, path = this.atPath(at, i)).isEmpty()) {
                    ++actual;
                    evaluatedItems.add(path);
                }
                ++i;
            }
            if (actual < this.min) {
                if (this.isMinV201909) {
                    this.updateValidatorType(ValidatorTypeCode.MIN_CONTAINS);
                }
                return this.boundsViolated(this.isMinV201909 ? CONTAINS_MIN : ValidatorTypeCode.CONTAINS.getValue(), at, this.min);
            }
            if (actual > this.max) {
                if (this.isMinV201909) {
                    this.updateValidatorType(ValidatorTypeCode.MAX_CONTAINS);
                }
                return this.boundsViolated(this.isMinV201909 ? CONTAINS_MAX : ValidatorTypeCode.CONTAINS.getValue(), at, this.max);
            }
        }
        return Collections.emptySet();
    }

    @Override
    public void preloadJsonSchema() {
        Optional.ofNullable(this.schema).ifPresent(JsonSchema::initializeValidators);
    }

    private Set<ValidationMessage> boundsViolated(String messageKey, String at, int bounds) {
        return Collections.singleton(this.constructValidationMessage(messageKey, at, String.valueOf(bounds), this.schema.getSchemaNode().toString()));
    }
}

