/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.networknt.schema.Collector;
import com.networknt.schema.ThreadInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CollectorContext {
    static final String COLLECTOR_CONTEXT_THREAD_LOCAL_KEY = "com.networknt.schema.CollectorKey";
    private Map<String, Object> collectorMap = new HashMap<String, Object>();
    private Map<String, Object> collectorLoadMap = new HashMap<String, Object>();
    private Collection<String> evaluatedItems = new ArrayList<String>();
    private Collection<String> evaluatedProperties = new ArrayList<String>();

    public static CollectorContext getInstance() {
        return (CollectorContext)ThreadInfo.get(COLLECTOR_CONTEXT_THREAD_LOCAL_KEY);
    }

    public Collection<String> getEvaluatedItems() {
        return this.evaluatedItems;
    }

    public void setEvaluatedItems(Collection<String> paths) {
        this.evaluatedItems = null != paths ? paths : new ArrayList();
    }

    public void resetEvaluatedItems() {
        this.evaluatedItems = new ArrayList<String>();
    }

    public Collection<String> getEvaluatedProperties() {
        return this.evaluatedProperties;
    }

    public void setEvaluatedProperties(Collection<String> paths) {
        this.evaluatedProperties = null != paths ? paths : new ArrayList();
    }

    public void resetEvaluatedProperties() {
        this.evaluatedProperties = new ArrayList<String>();
    }

    public <E> void add(String name, Collector<E> collector) {
        this.collectorMap.put(name, collector);
    }

    public <E> void add(String name, Object object) {
        this.collectorMap.put(name, object);
    }

    public Object get(String name) {
        Object object = this.collectorMap.get(name);
        if (object instanceof Collector && this.collectorLoadMap.get(name) != null) {
            return this.collectorLoadMap.get(name);
        }
        return this.collectorMap.get(name);
    }

    public Map<String, Object> getAll() {
        HashMap<String, Object> mergedMap = new HashMap<String, Object>();
        mergedMap.putAll(this.collectorMap);
        mergedMap.putAll(this.collectorLoadMap);
        return mergedMap;
    }

    public void combineWithCollector(String name, Object data) {
        Object object = this.collectorMap.get(name);
        if (object instanceof Collector) {
            Collector collector = (Collector)object;
            collector.combine(data);
        }
    }

    public void reset() {
        this.collectorMap = new HashMap<String, Object>();
        this.collectorLoadMap = new HashMap<String, Object>();
        this.evaluatedItems.clear();
        this.evaluatedProperties.clear();
    }

    void loadCollectors() {
        Set<Map.Entry<String, Object>> entrySet = this.collectorMap.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            if (!(entry.getValue() instanceof Collector)) continue;
            Collector collector = (Collector)entry.getValue();
            this.collectorLoadMap.put(entry.getKey(), collector.collect());
        }
    }
}

