/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.matching.EagerMatchResult;
import com.github.tomakehurst.wiremock.matching.WeightedMatchResult;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import wiremock.com.fasterxml.jackson.annotation.JsonCreator;
import wiremock.com.fasterxml.jackson.annotation.JsonIgnore;
import wiremock.com.fasterxml.jackson.annotation.JsonProperty;

public abstract class MatchResult
implements Comparable<MatchResult> {
    public static final Predicate<WeightedMatchResult> ARE_EXACT_MATCH = WeightedMatchResult::isExactMatch;

    @JsonCreator
    public static MatchResult partialMatch(@JsonProperty(value="distance") double distance) {
        return new EagerMatchResult(distance);
    }

    public static MatchResult exactMatch() {
        return new EagerMatchResult(0.0);
    }

    public static MatchResult noMatch() {
        return new EagerMatchResult(1.0);
    }

    public static MatchResult of(boolean isMatch) {
        return isMatch ? MatchResult.exactMatch() : MatchResult.noMatch();
    }

    public static MatchResult aggregate(MatchResult ... matches) {
        return MatchResult.aggregate(Arrays.asList(matches));
    }

    public static MatchResult aggregate(List<MatchResult> matchResults) {
        return MatchResult.aggregateWeighted(matchResults.stream().map(WeightedMatchResult::new).collect(Collectors.toList()));
    }

    public static MatchResult aggregateWeighted(WeightedMatchResult ... matchResults) {
        return MatchResult.aggregateWeighted(Arrays.asList(matchResults));
    }

    public static MatchResult aggregateWeighted(final List<WeightedMatchResult> matchResults) {
        return new MatchResult(){

            @Override
            public boolean isExactMatch() {
                return matchResults.stream().allMatch(ARE_EXACT_MATCH);
            }

            @Override
            public double getDistance() {
                double totalDistance = 0.0;
                double sizeWithWeighting = 0.0;
                for (WeightedMatchResult matchResult : matchResults) {
                    totalDistance += matchResult.getDistance();
                    sizeWithWeighting += matchResult.getWeighting();
                }
                return totalDistance / sizeWithWeighting;
            }
        };
    }

    @JsonIgnore
    public abstract boolean isExactMatch();

    public abstract double getDistance();

    @Override
    public int compareTo(MatchResult other) {
        return Double.compare(other.getDistance(), this.getDistance());
    }
}

