/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.common.HttpClientUtils;
import com.github.tomakehurst.wiremock.common.NetworkAddressRules;
import com.github.tomakehurst.wiremock.common.ProxySettings;
import com.github.tomakehurst.wiremock.common.ssl.KeyStoreSettings;
import com.github.tomakehurst.wiremock.global.GlobalSettings;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.HttpClientFactory;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.http.ResponseRenderer;
import com.github.tomakehurst.wiremock.store.SettingsStore;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.net.ssl.SSLException;
import wiremock.org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import wiremock.org.apache.hc.client5.http.entity.GzipCompressingEntity;
import wiremock.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import wiremock.org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import wiremock.org.apache.hc.core5.http.ContentType;
import wiremock.org.apache.hc.core5.http.Header;
import wiremock.org.apache.hc.core5.http.HttpEntity;
import wiremock.org.apache.hc.core5.http.HttpRequest;
import wiremock.org.apache.hc.core5.http.HttpResponse;
import wiremock.org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import wiremock.org.apache.hc.core5.http.io.entity.InputStreamEntity;

public class ProxyResponseRenderer
implements ResponseRenderer {
    private static final String TRANSFER_ENCODING = "transfer-encoding";
    private static final String CONTENT_ENCODING = "content-encoding";
    private static final String CONTENT_LENGTH = "content-length";
    private static final String HOST_HEADER = "host";
    public static final List<String> FORBIDDEN_RESPONSE_HEADERS = List.of("transfer-encoding", "connection");
    public static final List<String> FORBIDDEN_REQUEST_HEADERS = List.of("content-length", "transfer-encoding", "connection");
    private final CloseableHttpClient reverseProxyClient;
    private final CloseableHttpClient forwardProxyClient;
    private final boolean preserveHostHeader;
    private final String hostHeaderValue;
    private final SettingsStore settingsStore;
    private final boolean stubCorsEnabled;
    private final NetworkAddressRules targetAddressRules;

    public ProxyResponseRenderer(ProxySettings proxySettings, KeyStoreSettings trustStoreSettings, boolean preserveHostHeader, String hostHeaderValue, SettingsStore settingsStore, boolean trustAllProxyTargets, List<String> trustedProxyTargets, boolean stubCorsEnabled, NetworkAddressRules targetAddressRules, int proxyTimeout) {
        this.settingsStore = settingsStore;
        this.reverseProxyClient = HttpClientFactory.createClient(1000, proxyTimeout, proxySettings, trustStoreSettings, true, Collections.emptyList(), true);
        this.forwardProxyClient = HttpClientFactory.createClient(1000, proxyTimeout, proxySettings, trustStoreSettings, trustAllProxyTargets, trustAllProxyTargets ? Collections.emptyList() : trustedProxyTargets, false);
        this.preserveHostHeader = preserveHostHeader;
        this.hostHeaderValue = hostHeaderValue;
        this.stubCorsEnabled = stubCorsEnabled;
        this.targetAddressRules = targetAddressRules;
    }

    @Override
    public Response render(ServeEvent serveEvent) {
        Response response;
        block11: {
            ResponseDefinition responseDefinition = serveEvent.getResponseDefinition();
            if (this.targetAddressProhibited(responseDefinition.getProxyUrl())) {
                return Response.response().status(500).headers(new HttpHeaders(new HttpHeader("Content-Type", "text/plain"))).body("The target proxy address is denied in WireMock's configuration.").build();
            }
            HttpUriRequest httpRequest = ProxyResponseRenderer.getHttpRequestFor(responseDefinition);
            this.addRequestHeaders(httpRequest, responseDefinition);
            GlobalSettings settings = this.settingsStore.get();
            Request originalRequest = responseDefinition.getOriginalRequest();
            if (originalRequest.getBody() != null && originalRequest.getBody().length > 0 || originalRequest.containsHeader(CONTENT_LENGTH)) {
                httpRequest.setEntity(ProxyResponseRenderer.buildEntityFrom(originalRequest));
            }
            CloseableHttpClient client = this.buildClient(serveEvent.getRequest().isBrowserProxyRequest());
            CloseableHttpResponse httpResponse = client.execute(httpRequest);
            try {
                response = Response.response().status(httpResponse.getCode()).headers(this.headersFrom(httpResponse, responseDefinition)).body(HttpClientUtils.getEntityAsByteArrayAndCloseStream(httpResponse)).fromProxy(true).configureDelay(settings.getFixedDelay(), settings.getDelayDistribution(), responseDefinition.getFixedDelayMilliseconds(), responseDefinition.getDelayDistribution()).chunkedDribbleDelay(responseDefinition.getChunkedDribbleDelay()).build();
                if (httpResponse == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (httpResponse != null) {
                        try {
                            httpResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SSLException e) {
                    return this.proxyResponseError("SSL", httpRequest, e);
                }
                catch (IOException e) {
                    return this.proxyResponseError("Network", httpRequest, e);
                }
            }
            httpResponse.close();
        }
        return response;
    }

    private boolean targetAddressProhibited(String proxyUrl) {
        String host = URI.create(proxyUrl).getHost();
        try {
            InetAddress[] resolvedAddresses = InetAddress.getAllByName(host);
            return !Arrays.stream(resolvedAddresses).allMatch(address -> this.targetAddressRules.isAllowed(address.getHostAddress()));
        }
        catch (UnknownHostException e) {
            return true;
        }
    }

    private Response proxyResponseError(String type, HttpUriRequest request, Exception e) {
        return Response.response().status(500).body(type + " failure trying to make a proxied request from WireMock to " + ProxyResponseRenderer.extractUri(request) + "\r\n" + e.getMessage()).build();
    }

    private static String extractUri(HttpUriRequest request) {
        try {
            return request.getUri().toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            return request.getRequestUri();
        }
    }

    private CloseableHttpClient buildClient(boolean browserProxyRequest) {
        if (browserProxyRequest) {
            return this.forwardProxyClient;
        }
        return this.reverseProxyClient;
    }

    private HttpHeaders headersFrom(HttpResponse httpResponse, ResponseDefinition responseDefinition) {
        LinkedList<HttpHeader> httpHeaders = new LinkedList<HttpHeader>();
        for (Header header : httpResponse.getHeaders()) {
            if (!this.responseHeaderShouldBeTransferred(header.getName())) continue;
            httpHeaders.add(new HttpHeader(header.getName(), header.getValue()));
        }
        if (responseDefinition.getHeaders() != null) {
            httpHeaders.addAll(responseDefinition.getHeaders().all());
        }
        return new HttpHeaders(httpHeaders);
    }

    public static HttpUriRequest getHttpRequestFor(ResponseDefinition response) {
        RequestMethod method = response.getOriginalRequest().getMethod();
        String url = response.getProxyUrl();
        return HttpClientFactory.getHttpRequestFor(method, url);
    }

    private void addRequestHeaders(HttpRequest httpRequest, ResponseDefinition response) {
        Request originalRequest = response.getOriginalRequest();
        for (String key : originalRequest.getAllHeaderKeys()) {
            if (!ProxyResponseRenderer.requestHeaderShouldBeTransferred(key)) continue;
            if (!HOST_HEADER.equalsIgnoreCase(key) || this.preserveHostHeader) {
                List<String> values = originalRequest.header(key).values();
                for (String value : values) {
                    httpRequest.addHeader(key, value);
                }
                continue;
            }
            if (this.hostHeaderValue != null) {
                httpRequest.addHeader(key, this.hostHeaderValue);
                continue;
            }
            if (response.getProxyBaseUrl() == null) continue;
            httpRequest.addHeader(key, URI.create(response.getProxyBaseUrl()).getAuthority());
        }
        if (response.getAdditionalProxyRequestHeaders() != null) {
            for (String key : response.getAdditionalProxyRequestHeaders().keys()) {
                httpRequest.setHeader(key, response.getAdditionalProxyRequestHeaders().getHeader(key).firstValue());
            }
        }
    }

    private static boolean requestHeaderShouldBeTransferred(String key) {
        return !FORBIDDEN_REQUEST_HEADERS.contains(key.toLowerCase());
    }

    private boolean responseHeaderShouldBeTransferred(String key) {
        String lowerCaseKey = key.toLowerCase();
        return !FORBIDDEN_RESPONSE_HEADERS.contains(lowerCaseKey) && (!this.stubCorsEnabled || !lowerCaseKey.startsWith("access-control"));
    }

    private static HttpEntity buildEntityFrom(Request originalRequest) {
        ContentTypeHeader contentTypeHeader = originalRequest.contentTypeHeader().or("text/plain");
        ContentType contentType = ContentType.create(contentTypeHeader.mimeTypePart(), contentTypeHeader.encodingPart().orElse("utf-8"));
        if (originalRequest.containsHeader(TRANSFER_ENCODING) && originalRequest.header(TRANSFER_ENCODING).firstValue().equals("chunked")) {
            return ProxyResponseRenderer.applyGzipWrapperIfRequired(originalRequest, new InputStreamEntity(new ByteArrayInputStream(originalRequest.getBody()), -1L, contentType));
        }
        return ProxyResponseRenderer.applyGzipWrapperIfRequired(originalRequest, new ByteArrayEntity(originalRequest.getBody(), originalRequest.contentTypeHeader().isPresent() ? contentType : null));
    }

    private static HttpEntity applyGzipWrapperIfRequired(Request originalRequest, HttpEntity content) {
        if (originalRequest.containsHeader(CONTENT_ENCODING) && originalRequest.header(CONTENT_ENCODING).firstValue().contains("gzip")) {
            return new GzipCompressingEntity(content);
        }
        return content;
    }
}

