/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.io;

import com.github.jknack.handlebars.io.TemplateLoader;
import wiremock.org.apache.commons.lang3.StringUtils;
import wiremock.org.apache.commons.lang3.Validate;

public abstract class AbstractTemplateLoader
implements TemplateLoader {
    private String prefix = "/";
    private String suffix = ".hbs";

    @Override
    public String resolve(String uri) {
        return this.prefix + this.normalize(uri) + this.suffix;
    }

    protected String normalize(String location) {
        if (location.toString().startsWith("/")) {
            return location.substring(1);
        }
        return location;
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix = Validate.notNull(prefix, "A view prefix is required.", new Object[0]);
        if (!this.prefix.endsWith("/")) {
            this.prefix = this.prefix + "/";
        }
    }

    @Override
    public void setSuffix(String suffix) {
        this.suffix = StringUtils.defaultString(suffix, "");
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }
}

