/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.proxy;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import wiremock.org.eclipse.jetty.io.AbstractConnection;
import wiremock.org.eclipse.jetty.io.ByteBufferPool;
import wiremock.org.eclipse.jetty.io.Connection;
import wiremock.org.eclipse.jetty.io.EndPoint;
import wiremock.org.eclipse.jetty.proxy.ConnectHandler;
import wiremock.org.eclipse.jetty.util.Callback;
import wiremock.org.eclipse.jetty.util.IteratingCallback;
import wiremock.org.eclipse.jetty.util.log.Logger;

public abstract class ProxyConnection
extends AbstractConnection {
    protected static final Logger LOG = ConnectHandler.LOG;
    private final IteratingCallback pipe = new ProxyIteratingCallback();
    private final ByteBufferPool bufferPool;
    private final ConcurrentMap<String, Object> context;
    private Connection connection;

    protected ProxyConnection(EndPoint endp, Executor executor, ByteBufferPool bufferPool, ConcurrentMap<String, Object> context) {
        super(endp, executor);
        this.bufferPool = bufferPool;
        this.context = context;
    }

    public ByteBufferPool getByteBufferPool() {
        return this.bufferPool;
    }

    public ConcurrentMap<String, Object> getContext() {
        return this.context;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    @Override
    public void onFillable() {
        this.pipe.iterate();
    }

    protected abstract int read(EndPoint var1, ByteBuffer var2) throws IOException;

    protected abstract void write(EndPoint var1, ByteBuffer var2, Callback var3);

    @Override
    public String toString() {
        return String.format("%s[l:%d<=>r:%d]", super.toString(), this.getEndPoint().getLocalAddress().getPort(), this.getEndPoint().getRemoteAddress().getPort());
    }

    private class ProxyIteratingCallback
    extends IteratingCallback {
        private ByteBuffer buffer;
        private int filled;

        private ProxyIteratingCallback() {
        }

        @Override
        protected IteratingCallback.Action process() throws Exception {
            this.buffer = ProxyConnection.this.bufferPool.acquire(ProxyConnection.this.getInputBufferSize(), true);
            try {
                int filled = this.filled = ProxyConnection.this.read(ProxyConnection.this.getEndPoint(), this.buffer);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} filled {} bytes", ProxyConnection.this, filled);
                }
                if (filled > 0) {
                    ProxyConnection.this.write(ProxyConnection.this.connection.getEndPoint(), this.buffer, this);
                    return IteratingCallback.Action.SCHEDULED;
                }
                if (filled == 0) {
                    ProxyConnection.this.bufferPool.release(this.buffer);
                    ProxyConnection.this.fillInterested();
                    return IteratingCallback.Action.IDLE;
                }
                ProxyConnection.this.bufferPool.release(this.buffer);
                ProxyConnection.this.connection.getEndPoint().shutdownOutput();
                return IteratingCallback.Action.SUCCEEDED;
            }
            catch (IOException x) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(ProxyConnection.this + " could not fill", x);
                }
                this.disconnect();
                return IteratingCallback.Action.SUCCEEDED;
            }
        }

        @Override
        public void succeeded() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} wrote {} bytes", ProxyConnection.this, this.filled);
            }
            ProxyConnection.this.bufferPool.release(this.buffer);
            super.succeeded();
        }

        @Override
        protected void onCompleteSuccess() {
        }

        @Override
        protected void onCompleteFailure(Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(ProxyConnection.this + " failed to write " + this.filled + " bytes", x);
            }
            this.disconnect();
        }

        private void disconnect() {
            ProxyConnection.this.bufferPool.release(this.buffer);
            ProxyConnection.this.close();
            ProxyConnection.this.connection.close();
        }
    }
}

