/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.JsonData;
import java.io.IOException;
import wiremock.com.github.jknack.handlebars.Options;
import wiremock.com.jayway.jsonpath.InvalidJsonException;
import wiremock.com.jayway.jsonpath.JsonPath;
import wiremock.com.jayway.jsonpath.JsonPathException;
import wiremock.com.jayway.jsonpath.Predicate;

public class HandlebarsJsonPathHelper
extends HandlebarsHelper<Object> {
    @Override
    public Object apply(Object input, Options options) throws IOException {
        if (input == null) {
            return "";
        }
        if (options == null || options.param(0, null) == null) {
            return this.handleError("The JSONPath cannot be empty");
        }
        String jsonPath = (String)options.param(0);
        try {
            Object result = input instanceof String ? JsonPath.read((String)input, jsonPath, new Predicate[0]) : JsonPath.read(input, jsonPath, new Predicate[0]);
            return JsonData.create(result);
        }
        catch (InvalidJsonException e) {
            return this.handleError(input + " is not valid JSON", e.getJson(), e);
        }
        catch (JsonPathException e) {
            return this.handleError(jsonPath + " is not a valid JSONPath expression", e);
        }
    }
}

