/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.JsonData;
import java.io.IOException;
import wiremock.com.github.jknack.handlebars.Options;
import wiremock.com.jayway.jsonpath.InvalidJsonException;
import wiremock.com.jayway.jsonpath.JsonPath;
import wiremock.com.jayway.jsonpath.JsonPathException;
import wiremock.com.jayway.jsonpath.Predicate;

public class HandlebarsJsonPathHelper
extends HandlebarsHelper<String> {
    @Override
    public Object apply(String inputJson, Options options) throws IOException {
        if (inputJson == null) {
            return "";
        }
        if (options == null || options.param(0, null) == null) {
            return this.handleError("The JSONPath cannot be empty");
        }
        String jsonPath = (String)options.param(0);
        try {
            Object result = JsonPath.read(inputJson, jsonPath, new Predicate[0]);
            return JsonData.create(result);
        }
        catch (InvalidJsonException e) {
            return this.handleError(inputJson + " is not valid JSON", e.getJson(), e);
        }
        catch (JsonPathException e) {
            return this.handleError(jsonPath + " is not a valid JSONPath expression", e);
        }
    }
}

