/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.client;

import com.github.tomakehurst.wiremock.admin.AdminRoutes;
import com.github.tomakehurst.wiremock.admin.AdminTask;
import com.github.tomakehurst.wiremock.admin.OldRemoveStubMappingTask;
import com.github.tomakehurst.wiremock.admin.RequestSpec;
import com.github.tomakehurst.wiremock.admin.ResetRequestsTask;
import com.github.tomakehurst.wiremock.admin.ResetStubMappingsTask;
import com.github.tomakehurst.wiremock.admin.model.GetServeEventsResult;
import com.github.tomakehurst.wiremock.admin.model.ListStubMappingsResult;
import com.github.tomakehurst.wiremock.admin.model.PathParams;
import com.github.tomakehurst.wiremock.admin.model.SingleServedStubResult;
import com.github.tomakehurst.wiremock.admin.model.SingleStubMappingResult;
import com.github.tomakehurst.wiremock.admin.tasks.CreateStubMappingTask;
import com.github.tomakehurst.wiremock.admin.tasks.FindNearMissesForRequestPatternTask;
import com.github.tomakehurst.wiremock.admin.tasks.FindNearMissesForRequestTask;
import com.github.tomakehurst.wiremock.admin.tasks.FindNearMissesForUnmatchedTask;
import com.github.tomakehurst.wiremock.admin.tasks.FindRequestsTask;
import com.github.tomakehurst.wiremock.admin.tasks.FindUnmatchedRequestsTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetAllRequestsTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetAllStubMappingsTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetRequestCountTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetServedStubTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetStubMappingTask;
import com.github.tomakehurst.wiremock.admin.tasks.GlobalSettingsUpdateTask;
import com.github.tomakehurst.wiremock.admin.tasks.OldEditStubMappingTask;
import com.github.tomakehurst.wiremock.admin.tasks.ResetScenariosTask;
import com.github.tomakehurst.wiremock.admin.tasks.ResetTask;
import com.github.tomakehurst.wiremock.admin.tasks.ResetToDefaultMappingsTask;
import com.github.tomakehurst.wiremock.admin.tasks.SaveMappingsTask;
import com.github.tomakehurst.wiremock.admin.tasks.ShutdownServerTask;
import com.github.tomakehurst.wiremock.client.VerificationException;
import com.github.tomakehurst.wiremock.common.AdminException;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.HttpClientUtils;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.global.GlobalSettings;
import com.github.tomakehurst.wiremock.http.HttpClientFactory;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.verification.FindNearMissesResult;
import com.github.tomakehurst.wiremock.verification.FindRequestsResult;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.github.tomakehurst.wiremock.verification.VerificationResult;
import java.util.UUID;
import wiremock.com.google.common.base.Charsets;
import wiremock.com.google.common.base.Preconditions;
import wiremock.org.apache.http.client.methods.CloseableHttpResponse;
import wiremock.org.apache.http.client.methods.HttpGet;
import wiremock.org.apache.http.client.methods.HttpPost;
import wiremock.org.apache.http.client.methods.HttpUriRequest;
import wiremock.org.apache.http.client.methods.RequestBuilder;
import wiremock.org.apache.http.entity.StringEntity;
import wiremock.org.apache.http.impl.client.CloseableHttpClient;

public class HttpAdminClient
implements Admin {
    private static final String ADMIN_URL_PREFIX = "%s://%s:%d%s/__admin";
    private final String scheme;
    private final String host;
    private final int port;
    private final String urlPathPrefix;
    private final String hostHeader;
    private final AdminRoutes adminRoutes;
    private final CloseableHttpClient httpClient;

    public HttpAdminClient(String scheme, String host, int port) {
        this(scheme, host, port, "");
    }

    public HttpAdminClient(String host, int port, String urlPathPrefix) {
        this("http", host, port, urlPathPrefix);
    }

    public HttpAdminClient(String scheme, String host, int port, String urlPathPrefix) {
        this(scheme, host, port, urlPathPrefix, null);
    }

    public HttpAdminClient(String scheme, String host, int port, String urlPathPrefix, String hostHeader) {
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.urlPathPrefix = urlPathPrefix;
        this.hostHeader = hostHeader;
        this.adminRoutes = AdminRoutes.defaults();
        this.httpClient = HttpClientFactory.createClient();
    }

    public HttpAdminClient(String host, int port) {
        this(host, port, "");
    }

    @Override
    public void addStubMapping(StubMapping stubMapping) {
        if (stubMapping.getRequest().hasCustomMatcher()) {
            throw new AdminException("Custom matchers can't be used when administering a remote WireMock server. Use WireMockRule.stubFor() or WireMockServer.stubFor() to administer the local instance.");
        }
        this.executeRequest(this.adminRoutes.requestSpecForTask(CreateStubMappingTask.class), PathParams.empty(), stubMapping, Void.class, 201);
    }

    @Override
    public void editStubMapping(StubMapping stubMapping) {
        this.postJsonAssertOkAndReturnBody(this.urlFor(OldEditStubMappingTask.class), Json.write(stubMapping), 204);
    }

    @Override
    public void removeStubMapping(StubMapping stubbMapping) {
        this.postJsonAssertOkAndReturnBody(this.urlFor(OldRemoveStubMappingTask.class), Json.write(stubbMapping), 200);
    }

    @Override
    public ListStubMappingsResult listAllStubMappings() {
        return this.executeRequest(this.adminRoutes.requestSpecForTask(GetAllStubMappingsTask.class), ListStubMappingsResult.class);
    }

    @Override
    public SingleStubMappingResult getStubMapping(UUID id) {
        return this.executeRequest(this.adminRoutes.requestSpecForTask(GetStubMappingTask.class), PathParams.single("id", id), SingleStubMappingResult.class);
    }

    @Override
    public void saveMappings() {
        this.postJsonAssertOkAndReturnBody(this.urlFor(SaveMappingsTask.class), null, 200);
    }

    @Override
    public void resetAll() {
        this.postJsonAssertOkAndReturnBody(this.urlFor(ResetTask.class), null, 200);
    }

    @Override
    public void resetRequests() {
        this.executeRequest(this.adminRoutes.requestSpecForTask(ResetRequestsTask.class));
    }

    @Override
    public void resetScenarios() {
        this.executeRequest(this.adminRoutes.requestSpecForTask(ResetScenariosTask.class));
    }

    @Override
    public void resetMappings() {
        this.postJsonAssertOkAndReturnBody(this.urlFor(ResetStubMappingsTask.class), null, 200);
    }

    @Override
    public void resetToDefaultMappings() {
        this.postJsonAssertOkAndReturnBody(this.urlFor(ResetToDefaultMappingsTask.class), null, 200);
    }

    @Override
    public GetServeEventsResult getServeEvents() {
        return this.executeRequest(this.adminRoutes.requestSpecForTask(GetAllRequestsTask.class), GetServeEventsResult.class);
    }

    @Override
    public SingleServedStubResult getServedStub(UUID id) {
        return this.executeRequest(this.adminRoutes.requestSpecForTask(GetServedStubTask.class), PathParams.single("id", id), SingleServedStubResult.class);
    }

    @Override
    public VerificationResult countRequestsMatching(RequestPattern requestPattern) {
        String body = this.postJsonAssertOkAndReturnBody(this.urlFor(GetRequestCountTask.class), Json.write(requestPattern), 200);
        return VerificationResult.from(body);
    }

    @Override
    public FindRequestsResult findRequestsMatching(RequestPattern requestPattern) {
        String body = this.postJsonAssertOkAndReturnBody(this.urlFor(FindRequestsTask.class), Json.write(requestPattern), 200);
        return Json.read(body, FindRequestsResult.class);
    }

    @Override
    public FindRequestsResult findUnmatchedRequests() {
        String body = this.getJsonAssertOkAndReturnBody(this.urlFor(FindUnmatchedRequestsTask.class), 200);
        return Json.read(body, FindRequestsResult.class);
    }

    @Override
    public FindNearMissesResult findNearMissesForUnmatchedRequests() {
        String body = this.getJsonAssertOkAndReturnBody(this.urlFor(FindNearMissesForUnmatchedTask.class), 200);
        return Json.read(body, FindNearMissesResult.class);
    }

    @Override
    public FindNearMissesResult findTopNearMissesFor(LoggedRequest loggedRequest) {
        String body = this.postJsonAssertOkAndReturnBody(this.urlFor(FindNearMissesForRequestTask.class), Json.write(loggedRequest), 200);
        return Json.read(body, FindNearMissesResult.class);
    }

    @Override
    public FindNearMissesResult findTopNearMissesFor(RequestPattern requestPattern) {
        String body = this.postJsonAssertOkAndReturnBody(this.urlFor(FindNearMissesForRequestPatternTask.class), Json.write(requestPattern), 200);
        return Json.read(body, FindNearMissesResult.class);
    }

    @Override
    public void updateGlobalSettings(GlobalSettings settings) {
        this.postJsonAssertOkAndReturnBody(this.urlFor(GlobalSettingsUpdateTask.class), Json.write(settings), 200);
    }

    @Override
    public void shutdownServer() {
        this.postJsonAssertOkAndReturnBody(this.urlFor(ShutdownServerTask.class), null, 200);
    }

    public int port() {
        return this.port;
    }

    private String postJsonAssertOkAndReturnBody(String url, String json, int expectedStatus) {
        HttpPost post = new HttpPost(url);
        if (json != null) {
            post.setEntity(HttpAdminClient.jsonStringEntity(json));
        }
        return this.safelyExecuteRequest(url, expectedStatus, post);
    }

    private static StringEntity jsonStringEntity(String json) {
        return new StringEntity(json, Charsets.UTF_8.name());
    }

    protected String getJsonAssertOkAndReturnBody(String url, int expectedStatus) {
        HttpGet get = new HttpGet(url);
        return this.safelyExecuteRequest(url, expectedStatus, get);
    }

    private void executeRequest(RequestSpec requestSpec) {
        this.executeRequest(requestSpec, PathParams.empty(), null, Void.class, 200);
    }

    private <B, R> R executeRequest(RequestSpec requestSpec, B requestBody, Class<R> responseType) {
        return this.executeRequest(requestSpec, PathParams.empty(), requestBody, responseType, 200);
    }

    private <B, R> R executeRequest(RequestSpec requestSpec, Class<R> responseType) {
        return this.executeRequest(requestSpec, PathParams.empty(), null, responseType, 200);
    }

    private <B, R> R executeRequest(RequestSpec requestSpec, PathParams pathParams, Class<R> responseType) {
        return this.executeRequest(requestSpec, pathParams, null, responseType, 200);
    }

    private <B, R> R executeRequest(RequestSpec requestSpec, PathParams pathParams, B requestBody, Class<R> responseType, int expectedStatus) {
        String url = String.format(ADMIN_URL_PREFIX + requestSpec.path(pathParams), this.scheme, this.host, this.port, this.urlPathPrefix);
        RequestBuilder requestBuilder = RequestBuilder.create(requestSpec.method().getName()).setUri(url);
        if (requestBody != null) {
            requestBuilder.setEntity(HttpAdminClient.jsonStringEntity(Json.write(requestBody)));
        }
        String responseBodyString = this.safelyExecuteRequest(url, expectedStatus, requestBuilder.build());
        return responseType == Void.class ? null : (R)Json.read(responseBodyString, responseType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String safelyExecuteRequest(String url, int expectedStatus, HttpUriRequest request) {
        if (this.hostHeader != null) {
            request.addHeader("Host", this.hostHeader);
        }
        try (CloseableHttpResponse response = this.httpClient.execute(request);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != expectedStatus) {
                throw new VerificationException("Expected status " + expectedStatus + " for " + url + " but was " + statusCode);
            }
            String string = HttpClientUtils.getEntityAsStringAndCloseStream(response);
            return string;
        }
        catch (Exception e) {
            return Exceptions.throwUnchecked(e, String.class);
        }
    }

    private String urlFor(Class<? extends AdminTask> taskClass) {
        RequestSpec requestSpec = this.adminRoutes.requestSpecForTask(taskClass);
        Preconditions.checkNotNull(requestSpec, "No admin task URL is registered for " + taskClass.getSimpleName());
        return String.format(ADMIN_URL_PREFIX + requestSpec.path(), this.scheme, this.host, this.port, this.urlPathPrefix);
    }
}

